/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.persistence.jdbm;

import de.uni_bremen.st.rcf.exceptions.IncompatibleAttributeTypesException;
import de.uni_bremen.st.rcf.persistence.AbstractAttributeBinding;
import de.uni_bremen.st.rcf.persistence.AbstractEntryBinding;
import de.uni_bremen.st.rcf.persistence.AbstractValueListBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.AttributeBinding;
import de.uni_bremen.st.rcf.persistence.jdbm.EntryBinding;
import de.uni_bremen.st.rcf.schema.AttributeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ValueListBinding<T>
extends AbstractValueListBinding<T> {
    private final AttributeBinding<T> attributeBinding;

    public ValueListBinding(AbstractAttributeBinding attribute, AbstractEntryBinding entry) {
        super(attribute, entry);
        this.attributeBinding = (AttributeBinding)attribute;
    }

    private void guaranteeListExistence(int id) {
        assert (this.attributeBinding.isList());
        if (!this.attributeBinding.isSet(id)) {
            this.attributeBinding.createList(id);
        }
    }

    @Override
    public boolean add(T e) {
        int id = this.entry.getId();
        this.guaranteeListExistence(id);
        List<T> values = this.attributeBinding.getList(id);
        return values.add(e);
    }

    @Override
    public void add(int arg0, T arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int arg0, Collection<? extends T> arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        int id = this.entry.getId();
        if (this.attributeBinding.isSet(id)) {
            this.attributeBinding.getList(id).clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        for (T t : this) {
            if (!o.equals(t)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        int id = this.entry.getId();
        if (!this.attributeBinding.isSet(id)) {
            throw new IndexOutOfBoundsException("There nothing stored in this list.");
        }
        return this.attributeBinding.getList(id).get(index);
    }

    @Override
    public int indexOf(Object o) {
        int id = this.entry.getId();
        if (!this.attributeBinding.isSet(id)) {
            return -1;
        }
        return this.attributeBinding.getList(id).indexOf(o);
    }

    @Override
    public boolean isEmpty() {
        int id = this.entry.getId();
        return !this.attributeBinding.isSet(id) || this.attributeBinding.getList(id).isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        int id = this.entry.getId();
        this.guaranteeListExistence(id);
        return this.attributeBinding.getList(id).iterator();
    }

    @Override
    public int lastIndexOf(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        int id = this.entry.getId();
        if (!this.attributeBinding.isSet(id)) {
            throw new IndexOutOfBoundsException("This list is empty.");
        }
        return this.attributeBinding.getList(id).remove(index);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, T object) {
        int id = this.entry.getId();
        this.guaranteeListExistence(id);
        return this.attributeBinding.getList(id).set(index, object);
    }

    @Override
    public int size() {
        int id = this.entry.getId();
        if (!this.attributeBinding.isSet(id)) {
            return 0;
        }
        return this.attributeBinding.getList(id).size();
    }

    @Override
    public List<T> subList(int arg0, int arg1) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        int id = this.entry.getId();
        if (!this.attributeBinding.isSet(id)) {
            return new Object[0];
        }
        return this.attributeBinding.getList(id).toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        int id = this.entry.getId();
        List<Object> list = this.attributeBinding.isSet(id) ? this.attributeBinding.getList(id) : new ArrayList();
        return list.toArray(a);
    }

    @Override
    public AbstractEntryBinding getReference(int index) {
        int otherId = (Integer)this.get(index);
        return new EntryBinding(this.attributeBinding.getReferencedRelation(), otherId);
    }

    @Override
    public AbstractEntryBinding setReference(int index, AbstractEntryBinding otherEntry) {
        Integer id = this.entry.getId();
        this.guaranteeListExistence(id);
        List<T> values = this.attributeBinding.getList(id);
        values.set(index, otherEntry.getId());
        return null;
    }

    @Override
    public boolean addReference(AbstractEntryBinding binding) {
        if (!this.attributeBinding.isList()) {
            throw new IncompatibleAttributeTypesException();
        }
        if (this.attributeBinding.type != AttributeType.REFERENCE) {
            throw new IncompatibleAttributeTypesException();
        }
        int id = this.entry.getId();
        this.guaranteeListExistence(id);
        List<T> list = this.attributeBinding.getList(id);
        assert (list != null);
        list.add(binding.getId());
        this.attributeBinding.setList((Integer)id, list);
        return true;
    }

    @Override
    public void addReference(int index, AbstractEntryBinding binding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAllReference(int index, List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsReference(AbstractEntryBinding otherEntry) {
        int id = this.entry.getId();
        if (!this.attributeBinding.isSet(id)) {
            return false;
        }
        List<T> values = this.attributeBinding.getList(id);
        return values.contains(otherEntry.getId());
    }

    @Override
    public boolean containsAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOfReference(AbstractEntryBinding otherEntry) {
        return this.indexOf(otherEntry.getId());
    }

    @Override
    public int lastIndexOfReference(AbstractEntryBinding entryBinding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeReference(AbstractEntryBinding entryBinding) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractEntryBinding removeReferece(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAllReference(List<AbstractEntryBinding> entryBindingList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<AbstractEntryBinding> subListReference(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<AbstractEntryBinding> iteratorReference() {
        throw new UnsupportedOperationException();
    }
}

