/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.Attribute;
import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Files;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.Fragments;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Relation;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.schema.AttributeType;
import de.uni_bremen.st.rcf.util.FileRatio;
import de.uni_bremen.st.rcf.util.FileVersionHandler;
import de.uni_bremen.st.rcf.util.Pair;
import de.uni_bremen.st.rcf.util.TokenWrapper;
import de.uni_bremen.st.rcf.util.offsethandling.OffsetResolver;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.conqat.lib.scanner.ELanguage;
import org.conqat.lib.scanner.ETokenType;
import org.conqat.lib.scanner.ILenientScanner;
import org.conqat.lib.scanner.IToken;
import org.conqat.lib.scanner.ScannerFactory;
import org.conqat.lib.scanner.ScannerUtils;

public final class FileRatios {
    Map<FilePair, Pair<ArrayList<FragRange>, ArrayList<FragRange>>> filePairRanges = new HashMap<FilePair, Pair<ArrayList<FragRange>, ArrayList<FragRange>>>();
    Map<FilePair, Integer[]> relations = new HashMap<FilePair, Integer[]>();
    Map<FilePair, Pair<List<Fragment>, List<Fragment>>> fragmentsOfPairs = new HashMap<FilePair, Pair<List<Fragment>, List<Fragment>>>();
    Map<File, List<TokenWrapper>> fileTokens = new HashMap<File, List<TokenWrapper>>();

    private FileRatios() {
    }

    private void addPair(Fragment frag1, Fragment frag2, int type) {
        Integer[] second;
        FilePair key;
        Pair<ArrayList<FragRange>, ArrayList<FragRange>> rangePair;
        File file1 = frag1.getStart().getFile();
        File file2 = frag2.getStart().getFile();
        String filename1 = file1.getRelativePath();
        String filename2 = file2.getRelativePath();
        if (file1.getId() == file2.getId() || filename1.equals(filename2)) {
            return;
        }
        if (file1.getRelativePath().compareTo(file2.getRelativePath()) > 0) {
            Object tmp = frag1;
            frag1 = frag2;
            frag2 = tmp;
            tmp = file1;
            file1 = file2;
            file2 = (File)tmp;
            tmp = filename1;
            filename1 = filename2;
            filename2 = (String)tmp;
        }
        if ((rangePair = this.filePairRanges.get(key = new FilePair(file1, file2))) == null) {
            ArrayList first = new ArrayList();
            second = new ArrayList();
            rangePair = new Pair(first, second);
            this.filePairRanges.put(key, rangePair);
        }
        ((ArrayList)rangePair.first).add(new FragRange(frag1, frag2, true));
        ((ArrayList)rangePair.second).add(new FragRange(frag1, frag2, false));
        Integer[] rels = this.relations.get(key);
        if (rels == null) {
            rels = new Integer[]{0, 0, 0, 0};
            this.relations.put(key, rels);
        }
        if (type > 0 && type <= 3) {
            second = rels;
            int n = type;
            Integer.valueOf(second[n] + 1);
        }
        second = rels;
        Integer.valueOf(second[0] + 1);
        Pair<List<Fragment>, List<Fragment>> fragments = this.fragmentsOfPairs.get(key);
        if (fragments == null) {
            LinkedList first = new LinkedList();
            LinkedList second2 = new LinkedList();
            fragments = new Pair(first, second2);
            this.fragmentsOfPairs.put(key, fragments);
        }
        ((List)fragments.first).add(frag1);
        ((List)fragments.second).add(frag2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int countLines(File file) {
        String filename = file.getAbsolutePath();
        BufferedReader r = null;
        try {
            r = new BufferedReader(new FileReader(filename));
            int lines = 0;
            while (r.readLine() != null) {
                ++lines;
            }
            r.close();
            int n = lines;
            return n;
        }
        catch (IOException ioe) {
            System.err.format("Cannot determine loc of \"%s\"\n", filename);
            int n = 1;
            return n;
        }
        finally {
            try {
                r.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int mergeRanges(List<FragRange> rangePairs) {
        Collections.sort(rangePairs);
        int upper = 0;
        for (int lower = 1; lower < rangePairs.size(); ++lower) {
            if ((Integer)rangePairs.get((int)upper).second >= (Integer)rangePairs.get((int)lower).first) {
                if ((Integer)rangePairs.get((int)upper).second > (Integer)rangePairs.get((int)lower).second) {
                    rangePairs.get((int)lower).second = rangePairs.get((int)upper).second;
                }
                rangePairs.get((int)upper).second = (Integer)rangePairs.get((int)lower).first - 1;
            }
            ++upper;
        }
        int lines = 0;
        for (FragRange r : rangePairs) {
            lines += (Integer)r.second - (Integer)r.first + 1;
        }
        return lines;
    }

    private List<FileRatio> calculateFileRatios(Version version) {
        if (!OffsetResolver.getInstance().resolve(version)) {
            return new ArrayList<FileRatio>(this.filePairRanges.size());
        }
        for (ClonePair cp : version.getClonePairs()) {
            this.addPair(cp.getLeft(), cp.getRight(), cp.getType());
        }
        for (CloneClass cc : version.getCloneClasses()) {
            LinkedList<Fragment> seenFrags = new LinkedList<Fragment>();
            for (Fragment frag1 : cc.getFragments()) {
                for (Fragment frag2 : seenFrags) {
                    this.addPair(frag1, frag2, cc.getType());
                }
                seenFrags.add(frag1);
            }
        }
        ArrayList<FileRatio> result = new ArrayList<FileRatio>(this.filePairRanges.size());
        Relation<Entry> relFiles = version.getRelation().getRCF().getRelation("File");
        Attribute attrLoc = relFiles.getAttribute("loc");
        Attribute attrNumTkns = relFiles.getAttribute("numTokens");
        for (Map.Entry<FilePair, Pair<ArrayList<FragRange>, ArrayList<FragRange>>> entry : this.filePairRanges.entrySet()) {
            FilePair key = entry.getKey();
            Pair<ArrayList<FragRange>, ArrayList<FragRange>> rangePair = entry.getValue();
            FileRatio ratio = new FileRatio();
            ratio.getFirst().file = (File)key.first;
            ratio.getSecond().file = (File)key.second;
            ratio.getFirst().numOfLines = ratio.getFirst().file.isSet(attrLoc) ? ratio.getFirst().file.getLoc() : this.countLines(ratio.getFirst().file);
            ratio.getSecond().numOfLines = ratio.getSecond().file.isSet(attrLoc) ? ratio.getSecond().file.getLoc() : this.countLines(ratio.getSecond().file);
            if (ratio.getFirst().file.isSet(attrNumTkns)) {
                ratio.getFirst().numOfTokens = ratio.getFirst().file.getNumTokens();
            }
            if (ratio.getSecond().file.isSet(attrNumTkns)) {
                ratio.getSecond().numOfTokens = ratio.getSecond().file.getNumTokens();
            }
            ratio.getFirst().numOfClonedLines = this.mergeRanges((List)rangePair.first);
            ratio.getSecond().numOfClonedLines = this.mergeRanges((List)rangePair.second);
            ratio.getFirst().percentOfClonedLines = (double)ratio.getFirst().numOfClonedLines / (double)ratio.getFirst().numOfLines;
            ratio.getSecond().percentOfClonedLines = (double)ratio.getSecond().numOfClonedLines / (double)ratio.getSecond().numOfLines;
            if (ratio.getFirst().numOfTokens >= 0) {
                ratio.getFirst().numOfClonedTokens = this.mergeRangesTokens((List)rangePair.first, ratio.getFirst().file);
                ratio.getFirst().percentOfClonedTokens = (double)ratio.getFirst().numOfClonedTokens / (double)ratio.getFirst().numOfTokens;
            }
            if (ratio.getSecond().numOfTokens >= 0) {
                ratio.getSecond().numOfClonedTokens = this.mergeRangesTokens((List)rangePair.second, ratio.getSecond().file);
                ratio.getSecond().percentOfClonedTokens = (double)ratio.getSecond().numOfClonedTokens / (double)ratio.getSecond().numOfTokens;
            }
            Integer[] rels = this.relations.get(key);
            ratio.setNumOfRels(rels[0]);
            ratio.setNumOfType1(rels[1]);
            ratio.setNumOfType2(rels[2]);
            Pair<List<Fragment>, List<Fragment>> fragments = this.fragmentsOfPairs.get(key);
            assert (fragments != null);
            assert (ratio.getFirst().fragments == null);
            ratio.getFirst().fragments = new ArrayList((Collection)fragments.first);
            assert (ratio.getSecond().fragments == null);
            ratio.getSecond().fragments = new ArrayList((Collection)fragments.second);
            if (ratio.getFirst().percentOfClonedLines < ratio.getSecond().percentOfClonedLines) {
                ratio.swap();
            }
            result.add(ratio);
        }
        Collections.sort(result);
        return result;
    }

    private int mergeRangesTokens(List<FragRange> fragRanges, File file) {
        List<TokenWrapper> tokens = this.fileTokens.get(file);
        if (tokens == null) {
            try {
                String filename = FileVersionHandler.getInstance().getLastValidFile(file);
                tokens = this.scanFile(filename);
            }
            catch (FileNotFoundException e) {
                System.err.format("Cannot open file: %s\n", file.getAbsolutePath());
                return -1;
            }
            catch (IOException e) {
                System.err.format("An error occured during read of file: %s\n", file.getAbsolutePath());
                return -1;
            }
            this.fileTokens.put(file, tokens);
        }
        List<TokenRange> tokenRanges = this.mapRanges(fragRanges, tokens);
        int num = 0;
        for (TokenRange r : tokenRanges) {
            num += r.length;
        }
        return num;
    }

    private List<TokenRange> mapRanges(List<FragRange> fragRanges, List<TokenWrapper> tokens) {
        ArrayList<TokenRange> tokenRanges = new ArrayList<TokenRange>(fragRanges.size());
        int currToken = 0;
        for (FragRange fr : fragRanges) {
            int beginLine = (Integer)fr.first;
            int endLine = (Integer)fr.second;
            int tokenCount = 0;
            while (currToken < tokens.size() && tokens.get(currToken).getToken().getLineNumber() + 1 < beginLine) {
                ++currToken;
            }
            while (currToken < tokens.size() && tokens.get(currToken).getToken().getLineNumber() + 1 >= beginLine && tokens.get(currToken).getToken().getLineNumber() + 1 <= endLine) {
                ++tokenCount;
                ++currToken;
            }
            tokenRanges.add(new TokenRange(fr, tokenCount));
        }
        return tokenRanges;
    }

    private List<TokenWrapper> scanFile(String filename) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        ILenientScanner scanner = ScannerFactory.newLenientScanner(ELanguage.fromFileExtension(filename), reader, filename);
        List<IToken> scannerOutPut = ScannerUtils.readTokens(scanner);
        ArrayList<TokenWrapper> ret = new ArrayList<TokenWrapper>(scannerOutPut.size());
        int column = 0;
        int lineNumber = 0;
        for (IToken t : scannerOutPut) {
            column = lineNumber < t.getLineNumber() ? 0 : (column += t.getText().length());
            lineNumber = t.getLineNumber();
            if (t.getType().getTokenClass() == ETokenType.ETokenClass.COMMENT) continue;
            TokenWrapper tw = new TokenWrapper(t, column);
            ret.add(tw);
        }
        return ret;
    }

    public static void createSchema(RCF rcf) {
        Files relFiles = rcf.getFiles();
        Fragments relFrags = rcf.getFragments();
        if (!rcf.hasRelation("FileRatioPairs")) {
            Relation<Entry> relPairs = rcf.addRelation("FileRatioPairs");
            relPairs.addReferenceAttribute("left", relFrags);
            relPairs.addReferenceAttribute("right", relFrags);
            if (!rcf.hasRelation("FileRatios")) {
                Relation<Entry> relRatios = rcf.addRelation("FileRatios");
                relRatios.addReferenceAttribute("version", rcf.getVersions());
                relRatios.addReferenceListAttribute("pairs", AttributeType.REFERENCE, relPairs);
                relRatios.addReferenceAttribute("file1", relFiles);
                relRatios.addScalarAttribute("clonedLines1", AttributeType.INTEGER);
                relRatios.addScalarAttribute("percentOfClonedLines1", AttributeType.FLOAT);
                relRatios.addScalarAttribute("clonedTokens1", AttributeType.INTEGER);
                relRatios.addScalarAttribute("percentOfClonedTokens1", AttributeType.FLOAT);
                relRatios.addReferenceAttribute("file2", relFiles);
                relRatios.addScalarAttribute("clonedLines2", AttributeType.INTEGER);
                relRatios.addScalarAttribute("percentOfClonedLines2", AttributeType.FLOAT);
                relRatios.addScalarAttribute("clonedTokens2", AttributeType.INTEGER);
                relRatios.addScalarAttribute("percentOfClonedTokens2", AttributeType.FLOAT);
                relRatios.addScalarAttribute("type1Relations", AttributeType.INTEGER);
                relRatios.addScalarAttribute("type2Relations", AttributeType.INTEGER);
                relRatios.addScalarAttribute("totalRelations", AttributeType.INTEGER);
            }
        }
    }

    public static void calculateFileRatiosForAllVersions(RCF rcf) {
        FileRatios.calculateFileRatiosForAllVersions(rcf, false);
    }

    public static void calculateFileRations(Version version) {
        RCF rcf = version.getRelation().getRCF();
        Relation<Entry> relRatios = rcf.getRelation("FileRatios");
        Relation<Entry> relPairs = rcf.getRelation("FileRatioPairs");
        Attribute aLeft = relPairs.getAttribute("left");
        Attribute aRight = relPairs.getAttribute("right");
        Attribute aVersion = relRatios.getAttribute("version");
        Attribute aPairs = relRatios.getAttribute("pairs");
        Attribute aFile1 = relRatios.getAttribute("file1");
        Attribute aClonedLines1 = relRatios.getAttribute("clonedLines1");
        Attribute aPercentOfClonedLines1 = relRatios.getAttribute("percentOfClonedLines1");
        Attribute aClonedTokens1 = relRatios.getAttribute("clonedTokens1");
        Attribute aPercentOfClonedTokens1 = relRatios.getAttribute("percentOfClonedTokens1");
        Attribute aFile2 = relRatios.getAttribute("file2");
        Attribute aClonedLines2 = relRatios.getAttribute("clonedLines2");
        Attribute aPercentOfClonedLines2 = relRatios.getAttribute("percentOfClonedLines2");
        Attribute aClonedTokens2 = relRatios.getAttribute("clonedTokens2");
        Attribute aPercentOfClonedTokens2 = relRatios.getAttribute("percentOfClonedTokens2");
        Attribute aType1Relations = relRatios.getAttribute("type1Relations");
        Attribute aType2Relations = relRatios.getAttribute("type2Relations");
        Attribute aTotalRelations = relRatios.getAttribute("totalRelations");
        for (FileRatio ratio : FileRatios.getFileRatios(version)) {
            Entry e = relRatios.append();
            List<Entry> pList = e.getEntryList(aPairs);
            ArrayList<Fragment> leftFrags = ratio.getFirst().fragments;
            ArrayList<Fragment> rightFrags = ratio.getSecond().fragments;
            assert (leftFrags.size() == rightFrags.size());
            for (int i = 0; i < ratio.getFirst().fragments.size(); ++i) {
                Entry pair = relPairs.append();
                pair.setEntry(aLeft, (Entry)leftFrags.get(i));
                pair.setEntry(aRight, (Entry)rightFrags.get(i));
                pList.add(pair);
            }
            e.setEntry(aVersion, (Entry)version);
            e.setEntry(aFile1, (Entry)ratio.getFirst().file);
            e.setInt(aClonedLines1, ratio.getFirst().numOfClonedLines);
            e.setFloat(aPercentOfClonedLines1, (float)ratio.getFirst().percentOfClonedLines);
            if (ratio.getFirst().numOfTokens >= 0 && ratio.getFirst().numOfClonedTokens > 0) {
                e.setInt(aClonedTokens1, ratio.getFirst().numOfClonedTokens);
                e.setFloat(aPercentOfClonedTokens1, (float)ratio.getFirst().percentOfClonedTokens);
            }
            e.setEntry(aFile2, (Entry)ratio.getSecond().file);
            if (ratio.getSecond().numOfTokens >= 0 && ratio.getSecond().numOfClonedTokens > 0) {
                e.setInt(aClonedTokens2, ratio.getSecond().numOfClonedTokens);
                e.setFloat(aPercentOfClonedTokens2, (float)ratio.getSecond().percentOfClonedTokens);
            }
            e.setInt(aClonedLines2, ratio.getSecond().numOfClonedLines);
            e.setFloat(aPercentOfClonedLines2, (float)ratio.getSecond().percentOfClonedLines);
            e.setInt(aType1Relations, ratio.getNumOfType1());
            e.setInt(aType2Relations, ratio.getNumOfType2());
            e.setInt(aTotalRelations, ratio.getNumOfRels());
        }
    }

    public static void calculateFileRatiosForAllVersions(RCF rcf, boolean force) {
        if (rcf.hasRelation("FileRatios") && rcf.hasRelation("FileRatioPairs")) {
            if (rcf.getRelation("FileRatios").size() > 0 && !force) {
                return;
            }
        } else {
            FileRatios.createSchema(rcf);
        }
        Relation<Entry> relRatios = rcf.getRelation("FileRatios");
        Relation<Entry> relPairs = rcf.getRelation("FileRatioPairs");
        Attribute aLeft = relPairs.getAttribute("left");
        Attribute aRight = relPairs.getAttribute("right");
        Attribute aVersion = relRatios.getAttribute("version");
        Attribute aPairs = relRatios.getAttribute("pairs");
        Attribute aFile1 = relRatios.getAttribute("file1");
        Attribute aClonedLines1 = relRatios.getAttribute("clonedLines1");
        Attribute aPercentOfClonedLines1 = relRatios.getAttribute("percentOfClonedLines1");
        Attribute aClonedTokens1 = relRatios.getAttribute("clonedTokens1");
        Attribute aPercentOfClonedTokens1 = relRatios.getAttribute("percentOfClonedTokens1");
        Attribute aFile2 = relRatios.getAttribute("file2");
        Attribute aClonedLines2 = relRatios.getAttribute("clonedLines2");
        Attribute aPercentOfClonedLines2 = relRatios.getAttribute("percentOfClonedLines2");
        Attribute aClonedTokens2 = relRatios.getAttribute("clonedTokens2");
        Attribute aPercentOfClonedTokens2 = relRatios.getAttribute("percentOfClonedTokens2");
        Attribute aType1Relations = relRatios.getAttribute("type1Relations");
        Attribute aType2Relations = relRatios.getAttribute("type2Relations");
        Attribute aTotalRelations = relRatios.getAttribute("totalRelations");
        for (Version version : rcf.getVersions()) {
            for (FileRatio ratio : FileRatios.getFileRatios(version)) {
                Entry e = relRatios.append();
                List<Entry> pList = e.getEntryList(aPairs);
                ArrayList<Fragment> leftFrags = ratio.getFirst().fragments;
                ArrayList<Fragment> rightFrags = ratio.getSecond().fragments;
                assert (leftFrags.size() == rightFrags.size());
                for (int i = 0; i < ratio.getFirst().fragments.size(); ++i) {
                    Entry pair = relPairs.append();
                    pair.setEntry(aLeft, (Entry)leftFrags.get(i));
                    pair.setEntry(aRight, (Entry)rightFrags.get(i));
                    pList.add(pair);
                }
                e.setEntry(aVersion, (Entry)version);
                e.setEntry(aFile1, (Entry)ratio.getFirst().file);
                e.setInt(aClonedLines1, ratio.getFirst().numOfClonedLines);
                e.setFloat(aPercentOfClonedLines1, (float)ratio.getFirst().percentOfClonedLines);
                e.setInt(aClonedTokens1, ratio.getFirst().numOfClonedTokens);
                e.setFloat(aPercentOfClonedTokens1, (float)ratio.getFirst().percentOfClonedTokens);
                e.setEntry(aFile2, (Entry)ratio.getSecond().file);
                e.setInt(aClonedLines2, ratio.getSecond().numOfClonedLines);
                e.setFloat(aPercentOfClonedLines2, (float)ratio.getSecond().percentOfClonedLines);
                e.setInt(aClonedTokens2, ratio.getSecond().numOfClonedTokens);
                e.setFloat(aPercentOfClonedTokens2, (float)ratio.getSecond().percentOfClonedTokens);
                e.setInt(aType1Relations, ratio.getNumOfType1());
                e.setInt(aType2Relations, ratio.getNumOfType2());
                e.setInt(aTotalRelations, ratio.getNumOfRels());
            }
        }
    }

    public static List<FileRatio> getFileRatios(Version version) {
        return new FileRatios().calculateFileRatios(version);
    }

    public static String printFileRatios(Version version) {
        StringBuffer sb = new StringBuffer("File 1;cloned lines;clone rate;File2;cloned lines;clone rate;type 1 relations;type 2 relations;relations total\n");
        for (FileRatio r : new FileRatios().calculateFileRatios(version)) {
            sb.append(r.toString());
            sb.append('\n');
        }
        return sb.toString();
    }

    private class TokenRange {
        FragRange fragRange;
        int length;

        TokenRange(FragRange fragRange, int length) {
            this.fragRange = fragRange;
            this.length = length;
        }
    }

    private static class FragRange
    extends Pair<Integer, Integer>
    implements Comparable<FragRange> {
        public FragRange(Fragment frag1, Fragment frag2, boolean left) {
            super(0, 0);
            if (left) {
                this.first = frag1.getStart().getLine();
                this.second = frag1.getEnd().getLine();
            } else {
                this.first = frag2.getStart().getLine();
                this.second = frag2.getEnd().getLine();
            }
        }

        public FragRange(int i1, int i2) {
            super(i1, i2);
        }

        @Override
        public int compareTo(FragRange other) {
            if (((Integer)this.first).equals(other.first)) {
                return ((Integer)this.second).compareTo((Integer)other.second);
            }
            return ((Integer)this.first).compareTo((Integer)other.first);
        }
    }

    private static class FilePair
    extends Pair<File, File>
    implements Comparable<FilePair> {
        private int hash = ((File)this.first).getId() + 400 * ((File)this.second).getId();

        public FilePair(File f1, File f2) {
            super(f1, f2);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FilePair) {
                FilePair o = (FilePair)obj;
                return ((File)this.first).getId() == ((File)o.first).getId() && ((File)this.second).getId() == ((File)o.second).getId();
            }
            return super.equals(obj);
        }

        @Override
        public int compareTo(FilePair o) {
            return (((File)this.first).getRelativePath() + ";" + ((File)this.second).getRelativePath()).compareTo(((File)o.first).getRelativePath() + ";" + ((File)o.second).getRelativePath());
        }
    }
}

