/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.ClonePair;
import de.uni_bremen.st.rcf.model.Directory;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.SourcePosition;
import de.uni_bremen.st.rcf.model.Version;
import java.util.HashMap;

public class VersionExtractor {
    HashMap<Directory, Directory> directoryFromToMap = new HashMap();
    HashMap<File, File> fileFromToMap = new HashMap();

    public void extractVersion(RCF from, RCF to, int versionId) {
        Version v = (Version)from.getVersions().getEntry(versionId);
        Version toVersion = (Version)v.copy(to);
        for (Directory fromDir : v.getDirectories()) {
            Directory toDir = (Directory)fromDir.copy(to);
            this.directoryFromToMap.put(fromDir, toDir);
            toDir.setVersion(toVersion);
            toVersion.getDirectories().add(toDir);
        }
        for (File fromFile : v.getFiles()) {
            File toFile = (File)fromFile.copy(to);
            this.fileFromToMap.put(fromFile, toFile);
            toFile.setDirectory(this.directoryFromToMap.get(fromFile.getDirectory()));
            toFile.setVersion(toVersion);
            toVersion.getFiles().add(toFile);
        }
        for (CloneClass fromCC : v.getCloneClasses()) {
            CloneClass toCC = (CloneClass)fromCC.copy(to);
            toCC.setVersion(toVersion);
            for (Fragment fromFrag : fromCC.getFragments()) {
                Fragment toFrag = this.copyFragment(to, fromFrag);
                toCC.getFragments().add(toFrag);
                toFrag.getCloneClasses().add(toCC);
            }
            toVersion.getCloneClasses().add(toCC);
        }
        for (ClonePair fromCP : v.getClonePairs()) {
            ClonePair toCP = (ClonePair)fromCP.copy(to);
            toCP.setVersion(toVersion);
            toCP.setLeft(this.copyFragment(to, fromCP.getLeft()));
            toCP.setRight(this.copyFragment(to, fromCP.getRight()));
            toVersion.getClonePairs().add(toCP);
            toCP.getLeft().getClonePairs().add(toCP);
            toCP.getRight().getClonePairs().add(toCP);
        }
    }

    private Fragment copyFragment(RCF toRCF, Fragment from) {
        Fragment to = (Fragment)from.copy(toRCF);
        to.setStart(this.copySourcePosition(toRCF, from.getStart()));
        to.setEnd(this.copySourcePosition(toRCF, from.getEnd()));
        return to;
    }

    private SourcePosition copySourcePosition(RCF toRCF, SourcePosition from) {
        SourcePosition to = (SourcePosition)from.copy(toRCF);
        to.setFile(this.fileFromToMap.get(from.getFile()));
        return to;
    }
}

