/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util.offsethandling;

import de.uni_bremen.st.rcf.util.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class OffsetCounter {
    private String sourceCode = "";
    private List<Integer> linesLengths = new ArrayList<Integer>();

    public OffsetCounter(Reader reader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuilder stringBuilder = new StringBuilder();
        int lineCounter = 0;
        int character = -1;
        while ((character = bufferedReader.read()) > 0) {
            stringBuilder.append((char)character);
            ++lineCounter;
            if (character == 10) {
                this.linesLengths.add(lineCounter);
                lineCounter = 0;
                continue;
            }
            if (character != 13) continue;
            bufferedReader.mark(1);
            character = bufferedReader.read();
            if (character == 10) {
                stringBuilder.append((char)character);
                ++lineCounter;
            } else {
                bufferedReader.reset();
            }
            this.linesLengths.add(lineCounter);
            lineCounter = 0;
        }
        this.linesLengths.add(lineCounter);
        this.sourceCode = stringBuilder.toString();
        bufferedReader.close();
    }

    public Pair<Integer, Integer> countLineAndColumn(int offset) {
        if (offset > this.sourceCode.length()) {
            int lineLengthsSize = this.linesLengths.size();
            return new Pair<Integer, Integer>(lineLengthsSize - 1, this.linesLengths.get(lineLengthsSize - 1));
        }
        if (offset < 0) {
            return new Pair<Integer, Integer>(0, 0);
        }
        int line = 0;
        int lineLength = this.linesLengths.get(line);
        while (offset > lineLength) {
            offset -= lineLength;
            lineLength = this.linesLengths.get(++line);
        }
        return new Pair<Integer, Integer>(line + 1, offset + 1);
    }

    public int getOffset(int line, int column) {
        if (line < 1 || column < 1) {
            throw new IllegalArgumentException("line and column use 1 based index");
        }
        --column;
        --line;
        int offset = 0;
        for (int i = 0; i < line && i < this.linesLengths.size(); ++i) {
            int lineLength = this.linesLengths.get(i);
            offset += lineLength;
        }
        return offset + column;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public int countLineNumbers() {
        return this.linesLengths.size();
    }

    private void addLine(String line) {
        this.linesLengths.add(line.length());
        this.sourceCode = this.sourceCode + line;
    }
}

