/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.rcf.util.rcfdiff;

import de.uni_bremen.st.rcf.model.CloneClass;
import de.uni_bremen.st.rcf.model.Entry;
import de.uni_bremen.st.rcf.model.File;
import de.uni_bremen.st.rcf.model.Files;
import de.uni_bremen.st.rcf.model.Fragment;
import de.uni_bremen.st.rcf.model.RCF;
import de.uni_bremen.st.rcf.model.Version;
import de.uni_bremen.st.rcf.util.Pair;
import de.uni_bremen.st.rcf.util.PathUtils;
import de.uni_bremen.st.rcf.util.Ref;
import de.uni_bremen.st.rcf.util.offsethandling.OffsetResolver;
import de.uni_bremen.st.rcf.util.rcfdiff.Edge;
import de.uni_bremen.st.rcf.util.rcfdiff.EntriesMapping;
import de.uni_bremen.st.rcf.util.rcfdiff.FragmentComparator;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class RCFDiff {
    private static final Comparator<Fragment> COMP = new FragmentComparator();
    private RCF rcf1;
    private RCF rcf2;
    private EntriesMapping<Fragment> fragments;
    private EntriesMapping<CloneClass> cloneClasses;

    private RCFDiff(RCF rcf1, RCF rcf2) {
        assert (rcf1 != null);
        assert (rcf2 != null);
        this.rcf1 = rcf1;
        this.rcf2 = rcf2;
    }

    public static RCFDiff diff(RCF rcf1, RCF rcf2) {
        RCFDiff diff = new RCFDiff(rcf1, rcf2);
        diff.diff();
        return diff;
    }

    private <T extends Entry> void print(PrintStream out, String name, int numLeft, int numRight, List<Pair<T, List<Edge<T>>>> list) {
        int exact = 0;
        int near = 0;
        for (Pair<T, List<Edge<T>>> p : list) {
            if (((Edge)((List)p.second).get((int)0)).distance == 0) {
                ++exact;
                continue;
            }
            ++near;
        }
        out.format("%s:\n", name);
        out.format("\tleft:          %5d\n", numLeft);
        out.format("\tright:         %5d\n", numRight);
        out.format("\texact matched: %5d\n", exact);
        out.format("\tnear matched:  %5d\n", near);
        for (Pair<T, List<Edge<T>>> p : list) {
            Edge bestEdge = null;
            for (Edge e : (List)p.second) {
                if (bestEdge != null && e.distance >= bestEdge.distance) continue;
                bestEdge = e;
            }
            out.format("%5d -(%5d)-> %5d\n", ((Entry)p.first).getId(), bestEdge.distance, ((Entry)bestEdge.right).getId());
            if (((List)p.second).size() <= 1) continue;
            out.format("\t%d other:\n", ((List)p.second).size() - 1);
            for (Edge e : (List)p.second) {
                if (e.equals(bestEdge)) continue;
                out.format("\t~(%5d)~> %5d\n", e.distance, ((Entry)e.right).getId());
            }
        }
    }

    public void print(PrintStream out) {
        ArrayList ccs = new ArrayList();
        for (Map.Entry<CloneClass, List<Edge<CloneClass>>> entry : this.cloneClasses.getLeft().entrySet()) {
            ccs.add(new Pair<CloneClass, List<Edge<CloneClass>>>(entry.getKey(), entry.getValue()));
        }
        this.print(out, "Clone Classes", this.rcf1.getCloneClasses().size(), this.rcf2.getCloneClasses().size(), ccs);
        int numLeft = 0;
        int numRight = 0;
        ArrayList frags = new ArrayList();
        for (Fragment frag : this.rcf1.getFragments()) {
            if (this.cloneClasses.getLeft().containsKey(frag.getCloneClasses().get(0))) continue;
            ++numLeft;
            List<Edge<Fragment>> list = this.fragments.getLeft().get(frag);
            if (list == null) continue;
            frags.add(new Pair<Fragment, List<Edge<Fragment>>>(frag, list));
        }
        for (Fragment frag : this.rcf2.getFragments()) {
            if (this.cloneClasses.getLeft().containsKey(frag.getCloneClasses().get(0))) continue;
            ++numRight;
        }
        this.print(out, "Fragments without mapped clone class", numLeft, numRight, frags);
    }

    private void diff() {
        this.fragments = new EntriesMapping();
        this.cloneClasses = new EntriesMapping();
        this.resolveOffsets(this.rcf1);
        this.resolveOffsets(this.rcf2);
        this.mapFragments(this.rcf1.getFiles(), this.rcf2.getFiles());
        this.fragments.deleteInvalidMappings();
        this.mapCloneClasses();
        this.cloneClasses.deleteInvalidMappings();
    }

    private void mapCloneClasses() {
        LinkedList<Edge<Fragment>> leftExact = new LinkedList<Edge<Fragment>>();
        LinkedList<Edge<Fragment>> leftNear = new LinkedList<Edge<Fragment>>();
        for (Map.Entry<Fragment, List<Edge<Fragment>>> entry : this.fragments.getLeft().entrySet()) {
            Edge<Fragment> firstEdge = entry.getValue().get(0);
            if (firstEdge.distance == 0) {
                leftExact.add(firstEdge);
                continue;
            }
            leftNear.add(firstEdge);
        }
        this.mapCloneClasses(leftExact);
        this.mapCloneClasses(leftNear);
    }

    private void mapCloneClasses(List<Edge<Fragment>> fragsLeft) {
        for (Edge<Fragment> edge : fragsLeft) {
            Fragment fragLeft = (Fragment)edge.left;
            Fragment fragRight = (Fragment)edge.right;
            CloneClass ccLeft = fragLeft.getCloneClasses().get(0);
            CloneClass ccRight = fragRight.getCloneClasses().get(0);
            int attribDistance = this.calculateAttributeDistance(ccLeft, ccRight);
            LinkedList<Fragment> fragsRight = new LinkedList<Fragment>();
            for (Fragment f : ccRight.getFragments()) {
                fragsRight.add(f);
            }
            int exact = 0;
            int near = 0;
            int numFragments = 0;
            block2: for (Fragment frag1 : ccLeft.getFragments()) {
                ++numFragments;
                List<Edge<Fragment>> list1 = this.fragments.getLeft().get(frag1);
                if (list1 == null) continue;
                for (Edge<Fragment> e : list1) {
                    if (!fragsRight.contains(e.right)) continue;
                    if (e.distance == 0) {
                        ++exact;
                    } else {
                        ++near;
                    }
                    fragsRight.remove(e.right);
                    continue block2;
                }
            }
            if (attribDistance == 0) {
                if (exact == numFragments) {
                    this.cloneClasses.addExactMatch(ccLeft, ccRight);
                    continue;
                }
                if (exact + near != numFragments) continue;
                this.cloneClasses.addNearMatch(ccLeft, ccRight, this.calculateCCDistance(attribDistance, numFragments, exact, near));
                continue;
            }
            if (exact != numFragments) continue;
            this.cloneClasses.addNearMatch(ccLeft, ccRight, this.calculateCCDistance(attribDistance, numFragments, exact, near));
        }
    }

    private int calculateCCDistance(int attribDistance, int numFragments, int exact, int near) {
        return attribDistance + (numFragments - exact - near) * 2 + near;
    }

    private int calculateAttributeDistance(CloneClass cc1, CloneClass cc2) {
        int type2;
        int type1 = cc1.getType();
        return type1 == (type2 = cc2.getType()) ? 0 : 1;
    }

    private void resolveOffsets(RCF rcf) {
        for (Version v : rcf.getVersions()) {
            OffsetResolver.getInstance().resolve(v);
        }
    }

    private void mapFragments(Files files1, Files files2) {
        for (File file1 : files1) {
            if (file1.getFragments().size() <= 0) continue;
            String path = PathUtils.normalizePath(file1.getRelativePath());
            File file2 = files2.getFile(path, file1.getVersion());
            if (file2 == null) {
                System.err.format("Cannot find %s in right rcf.\n", path);
                continue;
            }
            this.mapFragmentsForFile(this.sortFragments(file1.getFragments(), new ArrayList<Fragment>()), this.sortFragments(file2.getFragments(), new LinkedList<Fragment>()));
        }
    }

    private void mapFragmentsForFile(List<Fragment> fragments1, List<Fragment> fragments2) {
        ListIterator<Fragment> iter = fragments2.listIterator();
        for (Fragment frag1 : fragments1) {
            this.checkMatch(frag1, iter);
        }
    }

    private boolean checkMatch(Fragment frag1, ListIterator<Fragment> iter) {
        int dStart;
        int distance;
        Fragment frag2;
        int bestDStart = Integer.MAX_VALUE;
        while (iter.hasNext()) {
            frag2 = iter.next();
            distance = this.calculateDistance(frag1, frag2);
            dStart = this.calculateDStart(frag1, frag2);
            if (distance == 0) {
                this.fragments.addExactMatch(frag1, frag2);
                iter.remove();
                return true;
            }
            if (dStart > bestDStart) break;
            bestDStart = dStart;
            this.fragments.addNearMatch(frag1, frag2, distance);
        }
        bestDStart = Integer.MAX_VALUE;
        while (iter.hasPrevious()) {
            frag2 = iter.previous();
            distance = this.calculateDistance(frag1, frag2);
            dStart = this.calculateDStart(frag1, frag2);
            if (distance == 0) {
                this.fragments.addExactMatch(frag1, frag2);
                iter.remove();
                return true;
            }
            if (dStart > bestDStart) break;
            bestDStart = dStart;
            this.fragments.addNearMatch(frag1, frag2, distance);
        }
        return false;
    }

    private int calculateDStart(Fragment frag1, Fragment frag2) {
        int start1 = frag1.getStart().getOffset();
        int start2 = frag2.getStart().getOffset();
        return Math.abs(start2 - start1);
    }

    private boolean checkNearMatch(Fragment frag1, Fragment frag2, Ref<Integer> smallestDistance) {
        int distance = this.calculateDistance(frag1, frag2);
        if (distance == 0) {
            assert (false) : "We missed an exact match somewhere. Any of the assumtions is wrong.";
        } else if (distance <= (Integer)smallestDistance.value) {
            this.fragments.addNearMatch(frag1, frag2, distance);
            smallestDistance.value = distance;
        } else {
            return false;
        }
        return true;
    }

    private int calculateDistance(Fragment frag1, Fragment frag2) {
        int start1 = frag1.getStart().getOffset();
        int start2 = frag2.getStart().getOffset();
        int end1 = frag1.getEnd().getOffset();
        int end2 = frag2.getEnd().getOffset();
        return Math.abs(start1 - start2) + Math.abs(end1 - end2);
    }

    private List<Fragment> sortFragments(Iterable<Fragment> fragments, List<Fragment> ret) {
        for (Fragment f : fragments) {
            ret.add(f);
        }
        Collections.sort(ret, COMP);
        return ret;
    }
}

