/*
 * Decompiled with CFR 0.152.
 */
package de.uni_bremen.st.reuse;

import de.uni_bremen.st.reuse.BauhausStreamConstants;
import de.uni_bremen.st.reuse.IBauhausStreamReader;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StreamCorruptedException;

public class BauhausStreamReader
extends BauhausStreamConstants
implements IBauhausStreamReader {
    private PushbackInputStream stream;
    private static int READ_BUFFER_SIZE = 262144;
    private File file;

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private int finishS32(short iHigh) throws IOException {
        if (iHigh >= 128 && iHigh <= 191) {
            return iHigh - 128;
        }
        if (iHigh >= 64 && iHigh <= 95) {
            return (iHigh - 64) * 256 + this.readU8();
        }
        if (iHigh >= 32 && iHigh <= 47) {
            return (iHigh - 32) * 65536 + this.readU8() * 256 + this.readU8();
        }
        if (iHigh >= 16 && iHigh <= 23) {
            return (iHigh - 16) * 0x1000000 + this.readU8() * 65536 + this.readU8() * 256 + this.readU8();
        }
        if (iHigh == 8) {
            return this.readU8() * 0x1000000 + this.readU8() * 65536 + this.readU8() * 256 + this.readU8();
        }
        if (iHigh >= 192 && iHigh <= 255) {
            return iHigh - 256;
        }
        if (iHigh >= 96 && iHigh <= 127) {
            return (iHigh - 128) * 256 + this.readU8();
        }
        if (iHigh >= 48 && iHigh <= 63) {
            return (iHigh - 64) * 65536 + this.readU8() * 256 + this.readU8();
        }
        if (iHigh >= 24 && iHigh <= 31) {
            return (iHigh - 32) * 0x1000000 + this.readU8() * 65536 + this.readU8() * 256 + this.readU8();
        }
        if (iHigh == 15) {
            return (this.readU8() - 256) * 0x1000000 + this.readU8() * 65536 + this.readU8() * 256 + this.readU8();
        }
        throw new StreamCorruptedException("32-bit signed int with an unknown high byte.");
    }

    @Override
    public boolean isEOF() throws IOException {
        int next = this.stream.read();
        if (next == -1) {
            return true;
        }
        this.stream.unread(next);
        return false;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.readU8() != 0;
    }

    @Override
    public <T extends Enum<T>> Enum<T> readEnum(Enum<T> enumerator) throws IOException {
        Enum[] values = (Enum[])enumerator.getClass().getEnumConstants();
        int maxOrdinal = 0;
        for (Enum e : values) {
            maxOrdinal = Math.max(maxOrdinal, e.ordinal());
        }
        if (maxOrdinal >= 0 && maxOrdinal <= 255) {
            return values[this.readU8()];
        }
        if (maxOrdinal >= 256 && maxOrdinal <= 65535) {
            return values[this.readU16()];
        }
        return values[this.readN32()];
    }

    @Override
    public int readInteger() throws IOException {
        return this.readS32();
    }

    @Override
    public byte readInteger8() throws IOException {
        return this.readS8();
    }

    @Override
    public long readLong() throws IOException {
        return this.readS64();
    }

    private int readN32() throws IOException {
        int iHigh = this.readN8();
        if (iHigh >= 128 && iHigh <= 255) {
            return iHigh - 128;
        }
        if (iHigh >= 64 && iHigh <= 127) {
            int i0 = this.readN8();
            return (iHigh - 64) * 256 + i0;
        }
        if (iHigh >= 32 && iHigh <= 63) {
            int i1 = this.readN8();
            int i0 = this.readN8();
            return (iHigh - 32) * 65536 + i1 * 256 + i0;
        }
        if (iHigh >= 16 && iHigh <= 31) {
            int i2 = this.readN8();
            int i1 = this.readN8();
            int i0 = this.readN8();
            return (iHigh - 16) * 0x1000000 + i2 * 65536 + i1 * 256 + i0;
        }
        if (iHigh == 8) {
            int i3 = this.readN8();
            int i2 = this.readN8();
            int i1 = this.readN8();
            int i0 = this.readN8();
            return i3 * 0x1000000 + i2 * 65536 + i1 * 256 + i0;
        }
        throw new RuntimeException("iHigh is " + iHigh);
    }

    private int readN8() throws IOException {
        short val = this.readU8();
        if (val >= 0) {
            return val;
        }
        return 256 + val;
    }

    @Override
    public int readNatural() throws IOException {
        return this.readN32();
    }

    private long readS64() throws IOException {
        short iHigh = this.readU8();
        if (iHigh == 0) {
            return (long)this.readU8() * 0x100000000000000L + (long)this.readU8() * 0x1000000000000L + (long)this.readU8() * 0x10000000000L + (long)this.readU8() * 0x100000000L + (long)this.readU8() * 0x1000000L + (long)this.readU8() * 65536L + (long)this.readU8() * 256L + (long)this.readU8();
        }
        return this.finishS32(iHigh);
    }

    private byte readS8() throws IOException, EOFException {
        int result = this.stream.read();
        if (result == -1) {
            throw new EOFException("End of stream reached");
        }
        return (byte)result;
    }

    private int readU16() throws IOException, EOFException {
        return this.readU8() * 256 + this.readU8();
    }

    private short readU8() throws IOException, EOFException {
        int result = this.stream.read();
        if (result == -1) {
            throw new EOFException("End of stream reached");
        }
        assert (result >= 0 && result <= 256) : "8-bit unsigned int out of range";
        return (short)result;
    }

    @Override
    public short readUnsigned8() throws IOException {
        return this.readS8();
    }

    @Override
    public long readUnsigned64() throws IOException {
        int base;
        int length;
        short high = this.readU8();
        long result = 0L;
        if (high == 0) {
            result = 0L;
            length = 9;
            base = 64;
        } else {
            int flag = 128;
            base = 0;
            length = 1;
            while ((high & flag) != flag) {
                base += 8;
                flag = (short)(flag / 2);
                ++length;
            }
            result = (long)(high ^ flag) * (long)Math.pow(2.0, base);
        }
        for (int index = 2; index <= length; ++index) {
            result += (long)this.readU8() * (long)Math.pow(2.0, base -= 8);
        }
        return result;
    }

    @Override
    public char readCharacter() throws IOException {
        short ord = this.readU8();
        return (char)ord;
    }

    @Override
    public float readFloat() throws IOException {
        String floatString = this.readShortString();
        if (floatString.equals("+MAX")) {
            return Float.MAX_VALUE;
        }
        if (floatString.equals("-MAX")) {
            return Float.MIN_VALUE;
        }
        return Float.parseFloat(floatString);
    }

    private String readShortString() throws IOException {
        short length = this.readU8();
        return this.readStringWithLength(length);
    }

    @Override
    public String readStringWithLength(int length) throws IOException {
        byte[] data = new byte[length];
        this.stream.read(data);
        return new String(data, "UTF-8");
    }

    @Override
    public double readDouble() throws IOException {
        String doubleString = this.readShortString();
        if (doubleString.equals("+MAX")) {
            return Double.MAX_VALUE;
        }
        if (doubleString.equals("-MAX")) {
            return Double.MIN_VALUE;
        }
        return Double.parseDouble(doubleString);
    }

    @Override
    public String readString() throws IOException {
        int length = this.readNatural();
        if (length == 0) {
            return "";
        }
        return this.readStringWithLength(length);
    }

    private int readS32() throws IOException {
        short iHigh = this.readU8();
        return this.finishS32(iHigh);
    }

    @Override
    public void open(String filename) throws IOException {
        this.file = new File(filename);
        if (!this.file.canRead()) {
            throw new RuntimeException("Not allowed to read file: " + filename);
        }
        if (this.isOpen()) {
            this.stream.close();
        }
        this.stream = new PushbackInputStream(new BufferedInputStream(new FileInputStream(filename), READ_BUFFER_SIZE));
    }

    @Override
    public void setStream(InputStream stream) {
        this.stream = new PushbackInputStream(stream);
    }

    @Override
    public boolean isOpen() {
        return this.stream != null;
    }
}

