/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.SortedSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTreeSet<E>
extends AbstractSet<E>
implements SortedSet<E> {
    private final SortedMap<E, Object> backingMap;

    BTreeSet(SortedMap<E, Object> map) {
        this.backingMap = map;
    }

    @Override
    public boolean add(E object) {
        return this.backingMap.put(object, "") == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return super.addAll(collection);
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.backingMap.comparator();
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public E first() {
        return this.backingMap.firstKey();
    }

    @Override
    public E last() {
        return this.backingMap.lastKey();
    }

    @Override
    public SortedSet<E> subSet(E start, E end) {
        int compare;
        Comparator<E> c = this.backingMap.comparator();
        int n = compare = c == null ? ((Comparable)start).compareTo(end) : c.compare(start, end);
        if (compare <= 0) {
            return new BTreeSet<E>(this.backingMap.subMap(start, end));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public SortedSet<E> headSet(E end) {
        Comparator<E> c = this.backingMap.comparator();
        if (c == null) {
            ((Comparable)end).compareTo(end);
        } else {
            c.compare(end, end);
        }
        return new BTreeSet<E>(this.backingMap.headMap(end));
    }

    @Override
    public SortedSet<E> tailSet(E start) {
        Comparator<E> c = this.backingMap.comparator();
        if (c == null) {
            ((Comparable)start).compareTo(start);
        } else {
            c.compare(start, start);
        }
        return new BTreeSet<E>(this.backingMap.tailMap(start));
    }
}

