/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import net.kotek.jdbm.BTree;
import net.kotek.jdbm.BTreeSet;
import net.kotek.jdbm.DB;
import net.kotek.jdbm.HTree;
import net.kotek.jdbm.HTreeSet;
import net.kotek.jdbm.LinkedList;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DBAbstract
implements DB {
    DBAbstract() {
    }

    abstract <A> long insert(A var1, Serializer<A> var2, boolean var3) throws IOException;

    abstract void delete(long var1) throws IOException;

    abstract <A> void update(long var1, A var3, Serializer<A> var4) throws IOException;

    abstract <A> A fetch(long var1, Serializer<A> var3) throws IOException;

    abstract <A> A fetch(long var1, Serializer<A> var3, boolean var4) throws IOException;

    public long insert(Object obj) throws IOException {
        return this.insert(obj, this.defaultSerializer(), false);
    }

    public void update(long recid, Object obj) throws IOException {
        this.update(recid, obj, this.defaultSerializer());
    }

    public <A> A fetch(long recid) throws IOException {
        return this.fetch(recid, this.defaultSerializer());
    }

    @Override
    public <K, V> Map<K, V> getHashMap(String name) {
        try {
            long recid = this.assertNameExist(name);
            HTree tree = (HTree)this.fetch(recid);
            tree.setPersistenceContext(this);
            if (!tree.hasValues()) {
                throw new ClassCastException("HashSet is not HashMap");
            }
            return tree;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <K, V> Map<K, V> createHashMap(String name) {
        return this.createHashMap(name, null, null);
    }

    @Override
    public synchronized <K, V> Map<K, V> createHashMap(String name, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        try {
            this.assertNameNotExist(name);
            HTree<K, V> tree = new HTree<K, V>(this, keySerializer, valueSerializer, true);
            long recid = this.insert(tree);
            this.setNamedObject(name, recid);
            return tree;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> Set<K> getHashSet(String name) {
        try {
            long recid = this.assertNameExist(name);
            HTree tree = (HTree)this.fetch(recid);
            tree.setPersistenceContext(this);
            if (tree.hasValues()) {
                throw new ClassCastException("HashMap is not HashSet");
            }
            return new HTreeSet(tree);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> Set<K> createHashSet(String name) {
        return this.createHashSet(name, null);
    }

    @Override
    public synchronized <K> Set<K> createHashSet(String name, Serializer<K> keySerializer) {
        try {
            this.assertNameNotExist(name);
            HTree tree = new HTree(this, keySerializer, null, false);
            long recid = this.insert(tree);
            this.setNamedObject(name, recid);
            return new HTreeSet(tree);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <K, V> SortedMap<K, V> getTreeMap(String name) {
        try {
            long recid = this.assertNameExist(name);
            BTree t = BTree.load(this, recid);
            if (!t.hasValues()) {
                throw new ClassCastException("TreeSet is not TreeMap");
            }
            return t.asMap();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <K extends Comparable, V> SortedMap<K, V> createTreeMap(String name) {
        return this.createTreeMap(name, null, null, null);
    }

    @Override
    public synchronized <K, V> SortedMap<K, V> createTreeMap(String name, Comparator<K> keyComparator, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        try {
            this.assertNameNotExist(name);
            BTree<K, V> tree = BTree.createInstance(this, keyComparator, keySerializer, valueSerializer, true);
            this.setNamedObject(name, tree.getRecid());
            return tree.asMap();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> SortedSet<K> getTreeSet(String name) {
        try {
            long recid = this.assertNameExist(name);
            BTree t = BTree.load(this, recid);
            if (t.hasValues()) {
                throw new ClassCastException("TreeMap is not TreeSet");
            }
            return new BTreeSet(t.asMap());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public synchronized <K> SortedSet<K> createTreeSet(String name) {
        return this.createTreeSet(name, null, null);
    }

    @Override
    public synchronized <K> SortedSet<K> createTreeSet(String name, Comparator<K> keyComparator, Serializer<K> keySerializer) {
        try {
            this.assertNameNotExist(name);
            BTree tree = BTree.createInstance(this, keyComparator, keySerializer, null, false);
            this.setNamedObject(name, tree.getRecid());
            return new BTreeSet<K>(tree.asMap());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <K> List<K> createLinkedList(String name) {
        return this.createLinkedList(name, null);
    }

    @Override
    public <K> List<K> createLinkedList(String name, Serializer<K> serializer) {
        try {
            this.assertNameNotExist(name);
            LinkedList<K> list = new LinkedList<K>(this, serializer);
            long recid = this.insert(list);
            this.setNamedObject(name, recid);
            return list;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    @Override
    public <K> List<K> getLinkedList(String name) {
        try {
            long recid = this.assertNameExist(name);
            LinkedList list = (LinkedList)this.fetch(recid);
            list.setPersistenceContext(this);
            return list;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    private void assertNameNotExist(String name) throws IOException {
        if (this.getNamedObject(name) != 0L) {
            throw new IllegalArgumentException("Object with name '" + name + "' already exists");
        }
    }

    private long assertNameExist(String name) throws IOException {
        long recid = this.getNamedObject(name);
        if (recid == 0L) {
            throw new IllegalArgumentException("Object with name '" + name + "' does not exist");
        }
        return recid;
    }

    protected abstract long getNamedObject(String var1) throws IOException;

    protected abstract void setNamedObject(String var1, long var2) throws IOException;

    protected abstract Serializer defaultSerializer();
}

