/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import net.kotek.jdbm.DB;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.DBCache;
import net.kotek.jdbm.DBStore;

public class DBMaker {
    private byte cacheType = (byte)2;
    private int mruCacheSize = 2048;
    private String location = null;
    private boolean disableTransactions = false;
    private boolean readonly = false;
    private String password = null;
    private boolean useAES256Bit = true;
    private boolean useRandomAccessFile = false;
    private boolean autoClearRefCacheOnLowMem = true;

    public DBMaker(String location) {
        this.location = location;
    }

    public DBMaker enableWeakCache() {
        this.cacheType = (byte)3;
        return this;
    }

    public DBMaker enableSoftCache() {
        this.cacheType = (byte)4;
        return this;
    }

    public DBMaker enableHardCache() {
        this.cacheType = (byte)4;
        return this;
    }

    public DBMaker enableMRUCache() {
        this.cacheType = (byte)2;
        return this;
    }

    public DBMaker setMRUCacheSize(int cacheSize) {
        if (cacheSize < 0) {
            throw new IllegalArgumentException("Cache size is smaller than zero");
        }
        this.cacheType = (byte)2;
        return this;
    }

    public DBMaker disableCacheAutoClear() {
        this.autoClearRefCacheOnLowMem = false;
        return this;
    }

    public DBMaker enableEncryption(String password, boolean useAES256Bit) {
        this.password = password;
        this.useAES256Bit = useAES256Bit;
        return this;
    }

    public DBMaker readonly() {
        this.readonly = true;
        return this;
    }

    public DBMaker disableCache() {
        this.cacheType = 1;
        return this;
    }

    public DBMaker disableTransactions() {
        this.disableTransactions = true;
        return this;
    }

    public DBMaker useRandomAccessFile() {
        this.useRandomAccessFile = true;
        return this;
    }

    public DB build() {
        Cipher cipherIn = null;
        Cipher cipherOut = null;
        if (this.password != null) {
            try {
                byte[] salt = new byte[]{3, -34, 123, 53, 78, 121, -12, -1, 45, -12, -48, 89, 11, 100, 99, 8};
                SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
                PBEKeySpec spec = new PBEKeySpec(this.password.toCharArray(), salt, 1024, this.useAES256Bit ? 256 : 128);
                SecretKey tmp = factory.generateSecret(spec);
                SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
                String transform = "AES/CBC/NoPadding";
                IvParameterSpec params = new IvParameterSpec(salt);
                cipherIn = Cipher.getInstance(transform);
                cipherIn.init(1, (Key)secret, params);
                cipherOut = Cipher.getInstance(transform);
                cipherOut.init(2, (Key)secret, params);
                byte[] data = new byte[4096];
                byte[] encData = cipherIn.doFinal(data);
                if (encData.length != 4096) {
                    throw new Error("Block size changed after encryption, make sure you use '/NoPadding'");
                }
                byte[] data2 = cipherOut.doFinal(encData);
                for (int i = 0; i < data.length; ++i) {
                    if (data[i] == data2[i]) continue;
                    throw new Error("Encryption provided by JRE does not work");
                }
            }
            catch (Exception e) {
                throw new IOError(e);
            }
        }
        DBAbstract db = null;
        try {
            db = new DBStore(this.location, this.readonly, this.disableTransactions, cipherIn, cipherOut, this.useRandomAccessFile);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        if (this.cacheType == 2 || this.cacheType == 4 || this.cacheType == 5 || this.cacheType == 3) {
            db = new DBCache((DBStore)db, this.mruCacheSize, this.cacheType, this.autoClearRefCacheOnLowMem);
        } else if (this.cacheType != 1) {
            throw new IllegalArgumentException("Unknown cache type: " + this.cacheType);
        }
        return db;
    }
}

