/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

final class Location {
    private static int COMPRESS_RECID_BLOCK_SHIFT;
    private static long COMPRESS_RECID_OFFSET_MASK;

    Location() {
    }

    static long getBlock(long loc) {
        return loc >>> 12;
    }

    static short getOffset(long loc) {
        return (short)(loc & 0xFFFL);
    }

    static long toLong(long block, short offset) {
        return (block << 12) + (long)offset;
    }

    static long compressRecid(long recid) {
        long block = Location.getBlock(recid);
        short offset = Location.getOffset(recid);
        if ((offset = (short)(offset - 14)) % 6 != 0) {
            throw new InternalError("recid not dividable 6");
        }
        long slot = offset / 6;
        return (block << COMPRESS_RECID_BLOCK_SHIFT) + slot;
    }

    static long decompressRecid(long recid) {
        long block = recid >>> COMPRESS_RECID_BLOCK_SHIFT;
        short offset = (short)((recid & COMPRESS_RECID_OFFSET_MASK) * 6L + 14L);
        return Location.toLong(block, offset);
    }

    static {
        int shift = 1;
        while (1 << shift < 680) {
            ++shift;
        }
        COMPRESS_RECID_BLOCK_SHIFT = shift;
        COMPRESS_RECID_OFFSET_MASK = -1L >>> 64 - shift;
    }
}

