/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOException;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.FreeLogicalRowIdPageManager;
import net.kotek.jdbm.Location;
import net.kotek.jdbm.PageManager;
import net.kotek.jdbm.RecordFile;

final class LogicalRowIdManager {
    private final RecordFile file;
    private final PageManager pageman;
    private final FreeLogicalRowIdPageManager freeman;
    static final short ELEMS_PER_PAGE = 680;

    LogicalRowIdManager(RecordFile file, PageManager pageman, FreeLogicalRowIdPageManager freeman) throws IOException {
        this.file = file;
        this.pageman = pageman;
        this.freeman = freeman;
    }

    long insert(long physloc) throws IOException {
        long retval = this.freeman.get();
        if (retval == 0L) {
            long firstPage = this.pageman.allocate((short)2);
            short curOffset = 14;
            for (int i = 0; i < 680; ++i) {
                this.freeman.put(Location.toLong(-firstPage, curOffset));
                curOffset = (short)(curOffset + 6);
            }
            retval = this.freeman.get();
            if (retval == 0L) {
                throw new Error("couldn't obtain free translation");
            }
        }
        this.update(retval, physloc);
        return retval;
    }

    void forceInsert(long logicalRowId, long physLoc) throws IOException {
        if (this.fetch(logicalRowId) != 0L) {
            throw new Error("can not forceInsert, record already exists: " + logicalRowId);
        }
        this.update(logicalRowId, physLoc);
    }

    void delete(long logicalrowid) throws IOException {
        long block = -Location.getBlock(logicalrowid);
        BlockIo xlatPage = this.file.get(block);
        xlatPage.pageHeaderSetLocation(Location.getOffset(logicalrowid), 0L);
        this.file.release(block, true);
        this.freeman.put(logicalrowid);
    }

    void update(long logicalrowid, long physloc) throws IOException {
        long block = -Location.getBlock(logicalrowid);
        BlockIo xlatPage = this.file.get(block);
        xlatPage.pageHeaderSetLocation(Location.getOffset(logicalrowid), physloc);
        this.file.release(block, true);
    }

    long fetch(long logicalrowid) throws IOException {
        long block = -Location.getBlock(logicalrowid);
        long last = this.pageman.getLast((short)2);
        if (last - 1L > block) {
            return 0L;
        }
        short offset = Location.getOffset(logicalrowid);
        BlockIo xlatPage = this.file.get(block);
        long ret = xlatPage.pageHeaderGetLocation(offset);
        this.file.release(block, false);
        return ret;
    }

    void commit() throws IOException {
        this.freeman.commit();
    }

    void rollback() throws IOException {
        this.freeman.rollback();
    }
}

