/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.kotek.jdbm.LongHashMap;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.Storage;

class StorageMemory
implements Storage {
    private LongHashMap<byte[]> pages = new LongHashMap();
    private boolean transactionsDisabled;
    private ByteArrayOutputStream transLog;

    StorageMemory(boolean transactionsDisabled) {
        this.transactionsDisabled = transactionsDisabled;
    }

    public ByteBuffer read(long pageNumber) throws IOException {
        byte[] data = this.pages.get(pageNumber);
        if (data == null) {
            return ByteBuffer.wrap(RecordFile.CLEAN_DATA).asReadOnlyBuffer();
        }
        ByteBuffer b = ByteBuffer.wrap(data);
        if (!this.transactionsDisabled) {
            return b.asReadOnlyBuffer();
        }
        return b;
    }

    public void write(long pageNumber, ByteBuffer data) throws IOException {
        if (data.capacity() != 4096) {
            throw new IllegalArgumentException();
        }
        byte[] b = this.pages.get(pageNumber);
        if (this.transactionsDisabled && data.hasArray() && data.array() == b) {
            return;
        }
        if (b == null) {
            b = new byte[4096];
        }
        data.position(0);
        data.get(b, 0, 4096);
        this.pages.put(pageNumber, b);
    }

    public void sync() throws IOException {
    }

    public void forceClose() throws IOException {
        this.pages = null;
    }

    public DataInputStream readTransactionLog() {
        if (this.transLog == null) {
            return null;
        }
        DataInputStream ret = new DataInputStream(new ByteArrayInputStream(this.transLog.toByteArray()));
        try {
            ret.readShort();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        return ret;
    }

    public void deleteTransactionLog() {
        this.transLog = null;
    }

    public DataOutputStream openTransactionLog() throws IOException {
        if (this.transLog == null) {
            this.transLog = new ByteArrayOutputStream();
        }
        return new DataOutputStream(this.transLog);
    }

    public boolean isReadonly() {
        return false;
    }
}

