/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import javax.crypto.Cipher;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.LongPacker;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TransactionManager {
    private RecordFile owner;
    private DataOutputStream oos;
    private ArrayList<BlockIo> txn = new ArrayList();
    private int curTxn = -1;
    private Storage storage;
    private Cipher cipherIn;
    private Cipher cipherOut;
    private static final Comparator<BlockIo> BLOCK_IO_COMPARTOR = new Comparator<BlockIo>(){

        @Override
        public int compare(BlockIo block1, BlockIo block2) {
            if (block1.getBlockId() == block2.getBlockId()) {
                return 0;
            }
            if (block1.getBlockId() < block2.getBlockId()) {
                return -1;
            }
            return 1;
        }
    };

    TransactionManager(RecordFile owner, Storage storage, Cipher cipherIn, Cipher cipherOut) throws IOException {
        this.owner = owner;
        this.storage = storage;
        this.cipherIn = cipherIn;
        this.cipherOut = cipherOut;
        this.recover();
        this.open();
    }

    public void synchronizeLog() throws IOException {
        this.synchronizeLogFromMemory();
    }

    private void synchronizeLogFromMemory() throws IOException {
        this.close();
        TreeSet<BlockIo> blockList = new TreeSet<BlockIo>(BLOCK_IO_COMPARTOR);
        int numBlocks = 0;
        int writtenBlocks = 0;
        if (this.txn != null) {
            for (BlockIo block : this.txn) {
                if (blockList.contains(block)) {
                    block.decrementTransactionCount();
                } else {
                    ++writtenBlocks;
                    boolean result = blockList.add(block);
                }
                ++numBlocks;
            }
            this.txn = null;
        }
        this.synchronizeBlocks(blockList, true);
        this.owner.sync();
        this.open();
    }

    private void open() throws IOException {
        this.oos = this.storage.openTransactionLog();
        this.oos.writeShort(4960);
        this.oos.flush();
        this.curTxn = -1;
    }

    private void recover() throws IOException {
        DataInputStream ois = this.storage.readTransactionLog();
        if (ois == null) {
            return;
        }
        while (true) {
            ArrayList<BlockIo> blocks = null;
            try {
                int size = LongPacker.unpackInt(ois);
                blocks = new ArrayList<BlockIo>(size);
                for (int i = 0; i < size; ++i) {
                    BlockIo b = new BlockIo();
                    b.readExternal(ois, this.cipherOut);
                    blocks.add(b);
                }
            }
            catch (IOException e) {
                break;
            }
            this.synchronizeBlocks(blocks, false);
        }
        this.owner.sync();
        ois.close();
        this.storage.deleteTransactionLog();
    }

    private void synchronizeBlocks(Iterable<BlockIo> blocks, boolean fromCore) throws IOException {
        for (BlockIo cur : blocks) {
            this.owner.synch(cur);
            if (!fromCore) continue;
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur);
        }
    }

    private void setClean(ArrayList<BlockIo> blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.setClean();
        }
    }

    private void discardBlocks(ArrayList<BlockIo> blocks) throws IOException {
        for (BlockIo cur : blocks) {
            cur.decrementTransactionCount();
            if (cur.isInTransaction()) continue;
            this.owner.releaseFromTransaction(cur);
        }
    }

    void start() throws IOException {
        ++this.curTxn;
        if (this.curTxn == 1) {
            this.synchronizeLogFromMemory();
            this.curTxn = 0;
        }
        this.txn = new ArrayList();
    }

    void add(BlockIo block) throws IOException {
        block.incrementTransactionCount();
        this.txn.add(block);
    }

    void commit() throws IOException {
        LongPacker.packInt(this.oos, this.txn.size());
        for (BlockIo block : this.txn) {
            block.writeExternal(this.oos, this.cipherIn);
        }
        this.sync();
        this.setClean(this.txn);
    }

    private void sync() throws IOException {
        this.oos.flush();
    }

    void shutdown() throws IOException {
        this.synchronizeLogFromMemory();
        this.close();
    }

    private void close() throws IOException {
        this.sync();
        this.oos.close();
        this.oos = null;
    }

    void forceClose() throws IOException {
        this.oos.close();
        this.oos = null;
    }

    void synchronizeLogFromDisk() throws IOException {
        this.close();
        if (this.txn != null) {
            this.discardBlocks(this.txn);
            this.txn = null;
        }
        this.recover();
        this.open();
    }
}

