/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.assessment.RatingPartition;
import org.conqat.lib.commons.assessment.partition.IRatingPartitioner;
import org.conqat.lib.commons.assessment.partition.PartitioningException;
import org.conqat.lib.commons.collections.CollectionMap;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IFactory;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.string.StringUtils;

public class PartitionedRating {
    public static final String PARTITIONED_RATING_TAG = "@ConQAT.PartitionedRating";
    private static final Pattern PARTITIONED_RATING_PATTERN = Pattern.compile("(.*)@ConQAT.PartitionedRating +(\\S+) *", 2);
    private Class<? extends IRatingPartitioner> partitionerClass;
    private IRatingPartitioner partitioner;
    private final List<String> contentLines = new ArrayList<String>();
    private final List<Integer> tagLineNumbers = new ArrayList<Integer>();
    private final CollectionMap<String, RatingPartition, Queue<RatingPartition>> storedPartitions = new CollectionMap(new IFactory<Queue<RatingPartition>, NeverThrownRuntimeException>(){

        @Override
        public Queue<RatingPartition> create() throws NeverThrownRuntimeException {
            return new LinkedList<RatingPartition>();
        }
    });
    private String tagPrefix = null;
    private final List<RatingPartition> partitions = new ArrayList<RatingPartition>();

    public PartitionedRating(String content) throws PartitioningException {
        this(StringUtils.splitLinesAsList(content));
    }

    public PartitionedRating(String content, Class<? extends IRatingPartitioner> partitionerClass) throws PartitioningException {
        this(StringUtils.splitLinesAsList(content), partitionerClass);
    }

    public PartitionedRating(List<String> lines) throws PartitioningException {
        this(lines, null);
    }

    public PartitionedRating(List<String> lines, Class<? extends IRatingPartitioner> partitionerClass) throws PartitioningException {
        this.preprocessLines(lines);
        if (partitionerClass != null) {
            this.partitionerClass = partitionerClass;
        }
        if (this.partitionerClass == null) {
            throw new PartitioningException("No partitioner description found in code!");
        }
        this.initPartitioner(partitionerClass);
        this.createPartitions();
    }

    private void preprocessLines(List<String> lines) throws PartitioningException {
        int lineNumber = 0;
        for (String line : lines) {
            if (this.processRatingTag(line) || this.processPartitionTag(line)) {
                this.tagLineNumbers.add(lineNumber);
            } else {
                this.contentLines.add(line);
            }
            ++lineNumber;
        }
    }

    private boolean processRatingTag(String line) throws PartitioningException {
        if (this.tagPrefix != null) {
            return false;
        }
        Matcher ratingMatcher = PARTITIONED_RATING_PATTERN.matcher(line);
        if (!ratingMatcher.matches()) {
            return false;
        }
        this.tagPrefix = ratingMatcher.group(1);
        String className = ratingMatcher.group(2);
        try {
            this.partitionerClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new PartitioningException("Could not find partitioner class " + className);
        }
        if (!IRatingPartitioner.class.isAssignableFrom(this.partitionerClass)) {
            throw new PartitioningException("Given partitioner class " + className + " does not implement " + IRatingPartitioner.class.getSimpleName());
        }
        return true;
    }

    private boolean processPartitionTag(String line) {
        RatingPartition partition = RatingPartition.processPartitionTag(line);
        if (partition != null) {
            this.storedPartitions.add(partition.getName(), partition);
            return true;
        }
        return false;
    }

    private void initPartitioner(Class<? extends IRatingPartitioner> partitionerClass) throws PartitioningException {
        try {
            this.partitioner = this.partitionerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new PartitioningException("Could not create instance of partitioner: " + partitionerClass, e);
        }
        catch (IllegalAccessException e) {
            throw new PartitioningException("Could not create instance of partitioner: " + partitionerClass, e);
        }
    }

    private void createPartitions() throws PartitioningException {
        for (Region region : this.splitIntoRegions()) {
            Queue<RatingPartition> queue = this.storedPartitions.getCollection(region.getOrigin());
            RatingPartition partition = queue != null && !queue.isEmpty() ? queue.poll() : new RatingPartition(null, "", region.getOrigin());
            partition.setLinesAndContent(this.getOriginalLine(region.getStart()), this.getOriginalLine(region.getEnd()), this.contentLines.subList(region.getStart(), region.getEnd() + 1));
            this.partitions.add(partition);
        }
    }

    private List<Region> splitIntoRegions() throws PartitioningException {
        List<Region> regions = this.partitioner.partition(CollectionUtils.toArray(this.contentLines, String.class));
        Collections.sort(regions);
        int i = 1;
        while (i < regions.size()) {
            if (regions.get(i - 1).overlaps(regions.get(i))) {
                throw new PartitioningException("Partitioner seems to be broken as overlapping regions were returned!");
            }
            ++i;
        }
        return regions;
    }

    private int getOriginalLine(int line) {
        for (int skippedLine : this.tagLineNumbers) {
            if (skippedLine > line) break;
            ++line;
        }
        return line;
    }

    public UnmodifiableList<RatingPartition> getPartitions() {
        return CollectionUtils.asUnmodifiable(this.partitions);
    }

    public String getUpdatedContent() {
        if (this.tagLineNumbers.isEmpty()) {
            return null;
        }
        ArrayList<String> output = new ArrayList<String>();
        boolean hadTags = false;
        for (String line : this.contentLines) {
            if (output.size() == this.tagLineNumbers.get(0).intValue()) {
                this.insertTags(output);
                hadTags = true;
            }
            output.add(line);
        }
        if (!hadTags) {
            this.insertTags(output);
        }
        return StringUtils.concat(output, StringUtils.CR);
    }

    private void insertTags(List<String> output) {
        output.add(String.valueOf(this.tagPrefix) + PartitionedRating.createRatingTag(this.partitionerClass.getName()));
        for (RatingPartition partition : this.partitions) {
            output.add(String.valueOf(this.tagPrefix) + partition.getTag());
        }
    }

    static String createRatingTag(String partitionerName) {
        return "@ConQAT.PartitionedRating " + partitionerName;
    }
}

