/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment;

import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.assessment.PartitionedRating;
import org.conqat.lib.commons.assessment.Rating;
import org.conqat.lib.commons.assessment.RatingPartition;
import org.conqat.lib.commons.assessment.partition.PartitioningException;

public class RatingUtils {
    public static ETrafficLightColor calculateRating(String content) {
        Rating rating = new Rating(content);
        if (rating.getStoredRating() != null) {
            return rating.getRating();
        }
        try {
            PartitionedRating partitionedRating = new PartitionedRating(content);
            ETrafficLightColor result = ETrafficLightColor.UNKNOWN;
            for (RatingPartition partition : partitionedRating.getPartitions()) {
                result = ETrafficLightColor.getDominantColor(result, partition.getRating());
            }
            return result;
        }
        catch (PartitioningException e) {
            return ETrafficLightColor.RED;
        }
    }
}

