/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment.partition;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assessment.partition.IRatingPartitioner;
import org.conqat.lib.commons.region.Region;

public class ExplicitPartitioner
implements IRatingPartitioner {
    private static final String PARTITION_MARK = "@ConQAT.PartitionMark";

    @Override
    public List<Region> partition(String[] lines) {
        ArrayList<Region> regions = new ArrayList<Region>();
        int start = 0;
        String name = "INITIAL";
        int i = 0;
        while (i < lines.length) {
            int markPosition = lines[i].indexOf(PARTITION_MARK);
            if (markPosition >= 0) {
                this.insertRegion(start, i - 1, name, regions);
                start = i + 1;
                name = lines[i].substring(markPosition + PARTITION_MARK.length() + 1).trim();
            }
            ++i;
        }
        this.insertRegion(start, lines.length - 1, name, regions);
        return regions;
    }

    private void insertRegion(int start, int end, String name, List<Region> regions) {
        if (end < start) {
            return;
        }
        regions.add(new Region(start, end, name));
    }
}

