/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.assessment.partition;

import java.io.IOException;
import java.util.List;
import org.conqat.lib.commons.assessment.partition.IRatingPartitioner;
import org.conqat.lib.commons.assessment.partition.PartitioningException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.region.Region;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public abstract class RatingPartitionerTestBase
extends CCSMTestCaseBase {
    protected List<Region> partition(String filename, IRatingPartitioner partitioner) throws IOException, PartitioningException {
        List<String> lines = FileSystemUtils.readLinesUTF8(this.useCanonicalTestFile(filename));
        return partitioner.partition(CollectionUtils.toArray(lines, String.class));
    }

    protected static void assertRegionsEqual(List<Region> expected, List<Region> actual) {
        RatingPartitionerTestBase.assertEquals((String)RatingPartitionerTestBase.regionsToString(expected), (String)RatingPartitionerTestBase.regionsToString(actual));
    }

    private static String regionsToString(List<Region> regions) {
        StringBuilder sb = new StringBuilder();
        for (Region region : regions) {
            sb.append(String.valueOf(region.getStart()) + "-" + region.getEnd() + ": " + region.getOrigin() + StringUtils.CR);
        }
        return sb.toString();
    }
}

