/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import org.conqat.lib.commons.cache.CacheBase;

public abstract class SoftRefCacheBase<I, H, E, X extends Exception>
extends CacheBase<I, H, E, X> {
    private static int accessCounter = 0;
    private static int hitCounter = 0;
    private static int missBecauseNotInCacheCounter = 0;
    private static int missBecauseRemovedFromCacheCounter = 0;
    protected final HashMap<H, SoftReference<E>> cache = new HashMap();

    @Override
    public E getItem(I identifier) throws X {
        ++accessCounter;
        SoftReference<E> ref = this.cache.get(this.getHashKey(identifier));
        if (ref == null) {
            return this.obtainUncachedItem(identifier);
        }
        E item = ref.get();
        if (item == null) {
            return this.obtainGarbageCollectedItem(identifier);
        }
        ++hitCounter;
        return item;
    }

    private E obtainGarbageCollectedItem(I identifier) throws X {
        ++missBecauseRemovedFromCacheCounter;
        Object item = this.obtainItem(identifier);
        if (item == null) {
            this.cache.remove(this.getHashKey(identifier));
        } else {
            this.cache.put(this.getHashKey(identifier), new SoftReference(item));
        }
        return item;
    }

    private E obtainUncachedItem(I identifier) throws X {
        Object item = this.obtainItem(identifier);
        if (item != null) {
            this.cache.put(this.getHashKey(identifier), new SoftReference(item));
            ++missBecauseNotInCacheCounter;
        }
        return item;
    }

    public static String getStatistics() {
        StringBuilder stats = new StringBuilder();
        stats.append("#access: " + accessCounter);
        stats.append(" #hits: " + hitCounter);
        stats.append(" #miss (not cached): " + missBecauseNotInCacheCounter);
        stats.append(" #miss (removed): " + missBecauseRemovedFromCacheCounter);
        return stats.toString();
    }
}

