/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j;

import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.backend.ICacheBackend;
import org.conqat.lib.commons.factory.IParameterizedFactory;

public class BasicCache<K, V, X extends Exception>
implements ICache<K, V, X> {
    private final String name;
    private final ICacheBackend<K, V> backend;
    private final IParameterizedFactory<V, K, X> factory;
    private int hits = 0;
    private int misses = 0;
    private long missCostMillis = 0L;

    public BasicCache(String name, IParameterizedFactory<V, K, X> factory, ICacheBackend<K, V> backend) {
        this.name = name;
        this.factory = factory;
        this.backend = backend;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public V obtain(K key) throws X {
        V value = this.backend.retrieve(key);
        if (value != null) {
            ++this.hits;
            return value;
        }
        ++this.misses;
        long start = System.currentTimeMillis();
        value = this.factory.create(key);
        this.backend.store(key, value);
        this.missCostMillis += System.currentTimeMillis() - start;
        return value;
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public int getMisses() {
        return this.misses;
    }

    @Override
    public long getMissCostMillis() {
        return this.missCostMillis;
    }
}

