/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j;

import org.conqat.lib.commons.cache4j.CacheFactory;
import org.conqat.lib.commons.cache4j.CacheRuleParsingException;
import org.conqat.lib.commons.cache4j.CacheTestBase;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.SynchronizedCache;
import org.conqat.lib.commons.cache4j.ThreadLocalCache;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class CacheFactoryTest
extends CCSMTestCaseBase {
    public void testLifeCycle() throws CacheRuleParsingException {
        CacheFactory.getInstance().clearCaches();
        CacheFactory.getInstance().loadCacheConfiguration("# a comment \n.*Test -> THREADLOCAL:SINGLE:0 \n.*-other-.* -> SYNCHRONIZED:LRU:2 \n# last one is never used as we use first match \n.* -> NONE:OFF:0 \n");
        ICache<Integer, Integer, NeverThrownRuntimeException> cache1 = CacheFactory.obtainCache(CacheFactoryTest.class, CacheTestBase.SQUARING_FACTORY);
        CacheFactoryTest.assertTrue((boolean)(cache1 instanceof ThreadLocalCache));
        ICache<Integer, Integer, NeverThrownRuntimeException> cache2 = CacheFactory.obtainCache("some-other-name", CacheTestBase.SQUARING_FACTORY);
        CacheFactoryTest.assertTrue((boolean)(cache2 instanceof SynchronizedCache));
        this.excerciseCaches(cache1, cache2);
        String statistics = CacheFactory.getInstance().getStatistics();
        statistics = statistics.replaceAll("(?m);[0-9]+$", ";MISS_COST");
        String captions = "Name;Thread Support;Cache Strategy; Strategy Parameter; Hits; Misses; Miss Cost Millis\n";
        String expected = String.valueOf(captions) + "org.conqat.lib.commons.cache4j.CacheFactoryTest;THREADLOCAL;SINGLE;0;1;3;MISS_COST\n" + "some-other-name;SYNCHRONIZED;LRU;2;2;3;MISS_COST\n";
        CacheFactoryTest.assertEquals((String)StringUtils.normalizeLineBreaks(expected), (String)StringUtils.normalizeLineBreaks(statistics));
        cache1 = null;
        cache2 = null;
        int i = 0;
        while (i < 10) {
            System.gc();
            ++i;
        }
        CacheFactoryTest.assertEquals((String)StringUtils.normalizeLineBreaks(captions), (String)StringUtils.normalizeLineBreaks(CacheFactory.getInstance().getStatistics()));
    }

    private void excerciseCaches(ICache<Integer, Integer, NeverThrownRuntimeException> cache1, ICache<Integer, Integer, NeverThrownRuntimeException> cache2) {
        CacheFactoryTest.assertEquals((int)1, (int)cache1.obtain(1));
        CacheFactoryTest.assertEquals((int)1, (int)cache1.obtain(1));
        CacheFactoryTest.assertEquals((int)4, (int)cache1.obtain(2));
        CacheFactoryTest.assertEquals((int)1, (int)cache1.obtain(1));
        CacheFactoryTest.assertEquals((int)1, (int)cache2.obtain(1));
        CacheFactoryTest.assertEquals((int)1, (int)cache2.obtain(1));
        CacheFactoryTest.assertEquals((int)4, (int)cache2.obtain(2));
        CacheFactoryTest.assertEquals((int)1, (int)cache2.obtain(1));
        CacheFactoryTest.assertEquals((int)9, (int)cache2.obtain(3));
    }

    public void testException() {
        try {
            CacheFactory.getInstance().loadCacheConfiguration("# a comment \n.*Test -> UNKNOWN:SINGLE:0 \n.* -> NONE:OFF:0 \n");
            CacheFactoryTest.fail((String)"Expected exception");
        }
        catch (CacheRuleParsingException e) {
            CacheFactoryTest.assertEquals((String)"Unknown thread support: UNKNOWN (line: 2)", (String)e.getMessage());
        }
    }
}

