/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j;

import org.conqat.lib.commons.cache4j.ECacheThreadSupport;
import org.conqat.lib.commons.cache4j.ICache;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IParameterizedFactory;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public abstract class CacheTestBase
extends CCSMTestCaseBase {
    public static IParameterizedFactory<Integer, Integer, NeverThrownRuntimeException> SQUARING_FACTORY = new IParameterizedFactory<Integer, Integer, NeverThrownRuntimeException>(){

        @Override
        public Integer create(Integer i) {
            return i * i;
        }
    };

    public abstract ECacheThreadSupport getThreadSupport();

    public void testHitMiss() {
        ICache<Integer, Integer, NeverThrownRuntimeException> cache = this.getThreadSupport().createCache("test", SQUARING_FACTORY, ECachingStrategy.SINGLE.getBackend(0));
        CacheTestBase.assertEquals((int)4, (int)cache.obtain(2));
        CacheTestBase.assertEquals((int)4, (int)cache.obtain(2));
        CacheTestBase.assertEquals((int)16, (int)cache.obtain(4));
        CacheTestBase.assertEquals((int)4, (int)cache.obtain(2));
        CacheTestBase.assertEquals((int)64, (int)cache.obtain(8));
        CacheTestBase.assertEquals((int)64, (int)cache.obtain(8));
        CacheTestBase.assertEquals((int)64, (int)cache.obtain(8));
        CacheTestBase.assertEquals((String)"test", (String)cache.getName());
        CacheTestBase.assertEquals((int)3, (int)cache.getHits());
        CacheTestBase.assertEquals((int)4, (int)cache.getMisses());
    }
}

