/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.cache4j.backend;

import org.conqat.lib.commons.cache4j.backend.CacheBackendTestBase;
import org.conqat.lib.commons.cache4j.backend.ECachingStrategy;
import org.conqat.lib.commons.cache4j.backend.ICacheBackend;

public class LRUCacheBackendTest
extends CacheBackendTestBase {
    @Override
    protected <K, V> ICacheBackend<K, V> createBackend() {
        return ECachingStrategy.LRU.getBackend(2);
    }

    public void testConsistency() {
        ICacheBackend<Integer, Integer> backend = this.createBackend();
        LRUCacheBackendTest.assertNull(backend.retrieve(1));
        backend.store(1, 42);
        LRUCacheBackendTest.assertNull(backend.retrieve(2));
        LRUCacheBackendTest.assertEquals((int)42, (int)((Integer)backend.retrieve(1)));
        backend.store(2, 43);
        LRUCacheBackendTest.assertEquals((int)43, (int)((Integer)backend.retrieve(2)));
        LRUCacheBackendTest.assertEquals((int)42, (int)((Integer)backend.retrieve(1)));
        backend.store(3, 44);
        LRUCacheBackendTest.assertNull(backend.retrieve(2));
        LRUCacheBackendTest.assertEquals((int)44, (int)((Integer)backend.retrieve(3)));
        LRUCacheBackendTest.assertEquals((int)42, (int)((Integer)backend.retrieve(1)));
    }
}

