/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.clone;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.conqat.lib.commons.clone.DeepCloneException;
import org.conqat.lib.commons.clone.IDeepCloneable;

public class CloneUtils {
    public static void cloneMapEntries(Map<String, Object> source, Map<String, Object> target) throws DeepCloneException {
        for (String key : source.keySet()) {
            target.put(key, CloneUtils.cloneAsDeepAsPossible(source.get(key)));
        }
    }

    public static Object cloneAsDeepAsPossible(Object o) throws DeepCloneException {
        return CloneUtils.cloneAsDeepAsPossible(o, 3);
    }

    public static Object cloneAsDeepAsPossible(Object o, int maxDepth) throws DeepCloneException {
        block13: {
            if (maxDepth < 0) {
                throw new DeepCloneException("Reached maximal allowed cloning depth.");
            }
            --maxDepth;
            if (o != null) break block13;
            return null;
        }
        try {
            Method clone;
            if (o instanceof IDeepCloneable) {
                return ((IDeepCloneable)o).deepClone();
            }
            if (o instanceof Map) {
                HashMap<Object, Object> result = new HashMap<Object, Object>();
                Iterator iterator = ((Map)o).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry child;
                    Map.Entry entry = child = iterator.next();
                    result.put(CloneUtils.cloneAsDeepAsPossible(entry.getKey(), maxDepth), CloneUtils.cloneAsDeepAsPossible(entry.getValue(), maxDepth));
                }
                return result;
            }
            if (o instanceof Object[]) {
                Object[] result = (Object[])((Object[])o).clone();
                int i = 0;
                while (i < result.length) {
                    result[i] = CloneUtils.cloneAsDeepAsPossible(result[i], maxDepth);
                    ++i;
                }
                return result;
            }
            if (o instanceof Collection) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object child : (Collection)o) {
                    result.add(CloneUtils.cloneAsDeepAsPossible(child, maxDepth));
                }
                return result;
            }
            if (o instanceof Cloneable && Modifier.isPublic((clone = o.getClass().getMethod("clone", new Class[0])).getModifiers())) {
                return clone.invoke(o, new Object[0]);
            }
            return o;
        }
        catch (DeepCloneException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DeepCloneException(ex);
        }
    }
}

