/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.clone;

import java.util.ArrayList;
import java.util.HashSet;
import junit.framework.TestCase;
import org.conqat.lib.commons.clone.CloneUtils;
import org.conqat.lib.commons.clone.DeepCloneException;
import org.conqat.lib.commons.clone.DeepCloneable;

public class CloneUtilsTest
extends TestCase {
    public void testCloneAsDeepAsPossibleWithObject() throws Exception {
        Object original = new Object();
        Object clone = CloneUtils.cloneAsDeepAsPossible(original);
        CloneUtilsTest.assertSame((Object)original, (Object)clone);
    }

    public void testCloneAsDeepAsPossibleWithDeepCloneable() throws Exception {
        DeepCloneable original = new DeepCloneable();
        Object clone = CloneUtils.cloneAsDeepAsPossible(original);
        CloneUtilsTest.assertNotSame((Object)original, (Object)clone);
    }

    public void testCloneAsDeepAsPossibleWithList() throws Exception {
        ArrayList<Object> orig = new ArrayList<Object>();
        orig.add("test");
        orig.add(new HashSet());
        ArrayList clone = (ArrayList)CloneUtils.cloneAsDeepAsPossible(orig);
        CloneUtilsTest.assertNotSame(orig, (Object)clone);
        CloneUtilsTest.assertEquals(orig.get(0), clone.get(0));
        CloneUtilsTest.assertNotSame(orig.get(1), clone.get(1));
    }

    public void testCloneAsDeepAsPossibleArray() throws Exception {
        String[] original = new String[]{"test"};
        Object clone = CloneUtils.cloneAsDeepAsPossible(original);
        CloneUtilsTest.assertNotSame((Object)original, (Object)clone);
        CloneUtilsTest.assertTrue((boolean)(clone instanceof String[]));
        CloneUtilsTest.assertEquals((String)"test", (String)((String[])clone)[0]);
    }

    public void testClonable() throws DeepCloneException {
        Cloneable c = new Cloneable(){

            public Object clone() throws CloneNotSupportedException {
                return super.clone();
            }
        };
        Object clone = CloneUtils.cloneAsDeepAsPossible(c);
        CloneUtilsTest.assertNotSame((Object)c, (Object)clone);
        try {
            CloneUtils.cloneAsDeepAsPossible(new Cloneable(){});
            CloneUtilsTest.fail((String)"Expected exception.");
        }
        catch (DeepCloneException deepCloneException) {
            // empty catch block
        }
    }

    public void testRecursion() {
        ArrayList l = new ArrayList();
        l.add(l);
        try {
            CloneUtils.cloneAsDeepAsPossible(l);
            CloneUtilsTest.fail((String)"Expected exception.");
        }
        catch (DeepCloneException deepCloneException) {
            // empty catch block
        }
    }
}

