/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.PairList;

public class ArrayBackedMap<K, V>
implements Map<K, V> {
    private final PairList<K, V> list;

    public ArrayBackedMap() {
        this(4);
    }

    public ArrayBackedMap(int initialCapacity) {
        this.list = new PairList(initialCapacity);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean containsKey(Object key) {
        try {
            K cleanKey = this.internKey(key);
            int i = this.list.size() - 1;
            while (true) {
                if (i < 0) {
                    return false;
                }
                if (this.areEqual(cleanKey, this.list.getFirst(i))) {
                    return true;
                }
                --i;
            }
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    protected K internKey(Object key) throws ClassCastException {
        return (K)key;
    }

    protected boolean areEqual(K key1, K key2) {
        if (key1 == null) {
            return key2 == null;
        }
        return key1.equals(key2);
    }

    @Override
    public V get(Object key) {
        try {
            K cleanKey = this.internKey(key);
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.areEqual(cleanKey, this.list.getFirst(i))) {
                    return this.list.getSecond(i);
                }
                --i;
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        K cleanKey = this.internKey(key);
        int i = this.list.size() - 1;
        while (i >= 0) {
            if (this.areEqual(cleanKey, this.list.getFirst(i))) {
                V oldValue = this.list.getSecond(i);
                this.list.setSecond(i, value);
                return oldValue;
            }
            --i;
        }
        this.list.add(cleanKey, value);
        return null;
    }

    @Override
    public V remove(Object key) {
        try {
            K cleanKey = this.internKey(key);
            int i = this.list.size() - 1;
            while (i >= 0) {
                if (this.areEqual(cleanKey, this.list.getFirst(i))) {
                    V oldValue = this.list.getSecond(i);
                    int last = this.list.size() - 1;
                    if (i != last) {
                        this.list.setFirst(i, this.list.getFirst(last));
                        this.list.setSecond(i, this.list.getSecond(last));
                    }
                    this.list.removeLast();
                    return oldValue;
                }
                --i;
            }
        }
        catch (ClassCastException e) {
            return null;
        }
        return null;
    }

    @Override
    public boolean containsValue(Object value) {
        int i = this.list.size() - 1;
        while (i >= 0) {
            if (value == null ? this.list.getSecond(i) == null : value.equals(this.list.getSecond(i))) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashMap<K, V> map = new HashMap<K, V>();
        int i = this.list.size() - 1;
        while (i >= 0) {
            map.put(this.list.getFirst(i), this.list.getSecond(i));
            --i;
        }
        return map.entrySet();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return new HashSet<K>(this.list.extractFirstList());
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Collection<V> values() {
        return this.list.extractSecondList();
    }

    public String toString() {
        return this.list.toString();
    }
}

