/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.error.NeverThrownRuntimeException;
import org.conqat.lib.commons.factory.IFactory;

public class CollectionMap<K, V, C extends Collection<V>> {
    private final Map<K, C> map;
    private final IFactory<C, NeverThrownRuntimeException> collectionFactory;

    public CollectionMap(IFactory<C, NeverThrownRuntimeException> collectionFactory) {
        this(new HashMap(), collectionFactory);
    }

    public CollectionMap(Map<K, C> map, IFactory<C, NeverThrownRuntimeException> collectionFactory) {
        CCSMPre.isNotNull(map);
        CCSMPre.isNotNull(collectionFactory);
        this.map = map;
        this.collectionFactory = collectionFactory;
    }

    public C getCollection(K key) {
        return (C)((Collection)this.map.get(key));
    }

    public boolean add(K key, V value) {
        return this.getOrCreateCollection(key).add(value);
    }

    public boolean addAll(K key, Collection<? extends V> values) {
        return this.getOrCreateCollection(key).addAll(values);
    }

    C getOrCreateCollection(K key) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = (Collection)this.collectionFactory.create();
            this.map.put(key, collection);
        }
        return (C)collection;
    }

    public void addAll(CollectionMap<K, V, C> other) {
        for (Object key : other.getKeys()) {
            C collection = other.getCollection(key);
            if (collection == null) continue;
            this.addAll((K)key, (Collection<? extends V>)collection);
        }
    }

    public boolean contains(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.contains(value);
    }

    public boolean remove(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return false;
        }
        return collection.remove(value);
    }

    public boolean containsCollection(K key) {
        return this.map.containsKey(key);
    }

    public boolean removeCollection(K key) {
        return this.map.remove(key) != null;
    }

    public UnmodifiableSet<K> getKeys() {
        return CollectionUtils.asUnmodifiable(this.map.keySet());
    }

    public C getValues() {
        Collection result = (Collection)this.collectionFactory.create();
        for (Collection values : this.map.values()) {
            result.addAll(values);
        }
        return (C)result;
    }

    public void clear() {
        this.map.clear();
    }

    public Map<K, V[]> collectionsToArrays(Class<V> type) {
        HashMap map = new HashMap();
        for (Object key : this.getKeys()) {
            map.put(key, CollectionUtils.toArray(this.getCollection(key), type));
        }
        return map;
    }

    public String toString() {
        return this.map.toString();
    }
}

