/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.InvertingComparator;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;

public class CollectionUtilsTest
extends TestCase {
    public void testSort() {
        HashSet<String> set = new HashSet<String>();
        int stringCount = 100;
        int i = 0;
        while (i < stringCount) {
            set.add(StringUtils.randomString(10));
            ++i;
        }
        UnmodifiableSet unmodifiable = CollectionUtils.asUnmodifiable(set);
        List sortedList = CollectionUtils.sort(unmodifiable);
        this.assertSorted(sortedList);
    }

    public void testReverse() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 100;
        while (i >= 0) {
            list.add(i);
            --i;
        }
        UnmodifiableList unmodifiable = CollectionUtils.asUnmodifiable(list);
        List reversed = CollectionUtils.reverse(unmodifiable);
        this.assertSorted(reversed);
    }

    private <T extends Comparable<? super T>> void assertSorted(List<T> reversed) {
        int i = 1;
        while (i < reversed.size()) {
            CollectionUtilsTest.assertTrue((((Comparable)reversed.get(i)).compareTo(reversed.get(i - 1)) >= 0 ? 1 : 0) != 0);
            ++i;
        }
    }

    public void testSortCollectionWithComparator() {
        HashSet<String> set = new HashSet<String>();
        int stringCount = 100;
        int i = 0;
        while (i < stringCount) {
            set.add(StringUtils.randomString(10));
            ++i;
        }
        Collator collator = Collator.getInstance();
        List<Object> sortedList = CollectionUtils.sort(set, new InvertingComparator<Object>(collator));
        int i2 = 1;
        while (i2 < stringCount) {
            CollectionUtilsTest.assertTrue((collator.compare((String)sortedList.get(i2), (String)sortedList.get(i2 - 1)) <= 0 ? 1 : 0) != 0);
            ++i2;
        }
    }

    public void testAsHashSet() {
        HashSet<String> set = CollectionUtils.asHashSet("x", "y", "z");
        CollectionUtilsTest.assertEquals((int)3, (int)set.size());
        CollectionUtilsTest.assertTrue((boolean)set.containsAll(Arrays.asList("x", "y", "z")));
        set = CollectionUtils.asHashSet("x", "x", "z");
        CollectionUtilsTest.assertEquals((int)2, (int)set.size());
        CollectionUtilsTest.assertTrue((boolean)set.containsAll(Arrays.asList("x", "z")));
        set = CollectionUtils.asHashSet(new String[0]);
        CollectionUtilsTest.assertTrue((boolean)set.isEmpty());
    }

    public void testEmptyList() {
        UnmodifiableList emptyList = CollectionUtils.emptyList();
        CollectionUtilsTest.assertTrue((boolean)emptyList.isEmpty());
    }

    public void testEmptySet() {
        UnmodifiableSet emptySet = CollectionUtils.emptySet();
        CollectionUtilsTest.assertTrue((boolean)emptySet.isEmpty());
    }

    public void testEmptyMap() {
        UnmodifiableMap emptyMap = CollectionUtils.emptyMap();
        CollectionUtilsTest.assertTrue((boolean)emptyMap.isEmpty());
    }

    public void testToArray() {
        Object[] array = new String[]{"test1", "test2", "test3"};
        List<String> set = Arrays.asList(array);
        CollectionUtilsTest.assertTrue((boolean)Arrays.equals(array, CollectionUtils.toArray(set, String.class)));
        CollectionUtilsTest.assertTrue((CollectionUtils.toArray(new ArrayList(), String.class).length == 0 ? 1 : 0) != 0);
        Object[] objectArray = CollectionUtils.toArray(set, Object.class);
        CollectionUtilsTest.assertTrue((objectArray.length == 3 ? 1 : 0) != 0);
    }

    public void testCopyArray() {
        Object[] test = new String[]{"test1", "test2", "test3"};
        Object[] copy = CollectionUtils.copyArray(test);
        CollectionUtilsTest.assertTrue((boolean)Arrays.equals(test, copy));
        CollectionUtilsTest.assertNotSame((Object)test, (Object)copy);
        test = new String[]{};
        copy = (String[])CollectionUtils.copyArray(test);
        CollectionUtilsTest.assertEquals((int)0, (int)copy.length);
    }

    public void testComputeUnorderedPairs() {
        List<Integer> elements = Arrays.asList(1, 2, 3, 4);
        List<ImmutablePair<Integer, Integer>> unorderedPairs = CollectionUtils.computeUnorderedPairs(elements);
        CollectionUtilsTest.assertEquals((String)"Unexpected number of pairs", (int)6, (int)unorderedPairs.size());
        this.assertPair(unorderedPairs.get(0), 1, 2);
        this.assertPair(unorderedPairs.get(1), 1, 3);
        this.assertPair(unorderedPairs.get(2), 1, 4);
        this.assertPair(unorderedPairs.get(3), 2, 3);
        this.assertPair(unorderedPairs.get(4), 2, 4);
        this.assertPair(unorderedPairs.get(5), 3, 4);
    }

    private void assertPair(ImmutablePair<Integer, Integer> pair, int expectedFirst, int expectedSecond) {
        CollectionUtilsTest.assertEquals((int)expectedFirst, (int)((Integer)pair.first));
        CollectionUtilsTest.assertEquals((int)expectedSecond, (int)((Integer)pair.second));
    }

    public void testGetLast() {
        ArrayList<String> list = new ArrayList<String>();
        CollectionUtilsTest.assertEquals(null, (String)((String)CollectionUtils.getLast(list)));
        String s1 = "A";
        list.add(s1);
        CollectionUtilsTest.assertEquals((String)s1, (String)((String)CollectionUtils.getLast(list)));
        String s2 = "B";
        list.add(s2);
        CollectionUtilsTest.assertEquals((String)s2, (String)((String)CollectionUtils.getLast(list)));
        list.remove(s2);
        CollectionUtilsTest.assertEquals((String)s1, (String)((String)CollectionUtils.getLast(list)));
    }

    public void testAsRandomAccessList() {
        List<Integer> content = Arrays.asList(1, 2, 3, 4);
        ArrayList<Integer> randomAccess = new ArrayList<Integer>(content);
        List<Integer> result1 = CollectionUtils.asRandomAccessList(randomAccess);
        CollectionUtilsTest.assertSame(randomAccess, result1);
        LinkedList<Integer> nonRandomAccess = new LinkedList<Integer>(content);
        List<Integer> result2 = CollectionUtils.asRandomAccessList(nonRandomAccess);
        CollectionUtilsTest.assertNotSame(nonRandomAccess, result2);
        CollectionUtilsTest.assertEquals(content, result2);
    }
}

