/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class CounterSetTest
extends TestCase {
    private final CounterSet<String> counterSet = new CounterSet();

    public void setUp() {
        this.counterSet.inc("test1", 5);
        this.counterSet.inc("test2", 1);
    }

    public void testToString() {
        CounterSetTest.assertEquals((String)"{test1=5, test2=1}", (String)this.counterSet.toString());
    }

    public void testIncWithIncrement() {
        CounterSetTest.assertEquals((int)5, (int)this.counterSet.getValue("test1"));
        this.counterSet.inc("test1", 5);
        CounterSetTest.assertEquals((int)10, (int)this.counterSet.getValue("test1"));
        this.counterSet.inc("testX", 3);
        CounterSetTest.assertEquals((int)3, (int)this.counterSet.getValue("testX"));
    }

    public void testInc() {
        CounterSetTest.assertEquals((int)5, (int)this.counterSet.getValue("test1"));
        this.counterSet.inc("test1");
        CounterSetTest.assertEquals((int)6, (int)this.counterSet.getValue("test1"));
        this.counterSet.inc("testX");
        CounterSetTest.assertEquals((int)1, (int)this.counterSet.getValue("testX"));
    }

    public void testIncAll() {
        List<String> coll = Arrays.asList("a", "b", "a", "c", "a", "b");
        this.counterSet.incAll(coll);
        CounterSetTest.assertEquals((int)3, (int)this.counterSet.getValue("a"));
        CounterSetTest.assertEquals((int)2, (int)this.counterSet.getValue("b"));
        CounterSetTest.assertEquals((int)1, (int)this.counterSet.getValue("c"));
    }

    public void testRemove() {
        List<String> coll = Arrays.asList("a", "b", "a", "c", "a", "b");
        this.counterSet.incAll(coll);
        CounterSetTest.assertEquals((int)12, (int)this.counterSet.getTotal());
        this.counterSet.remove("a");
        CounterSetTest.assertEquals((int)0, (int)this.counterSet.getValue("a"));
        CounterSetTest.assertEquals((int)9, (int)this.counterSet.getTotal());
        this.counterSet.remove("does_not_exist");
        CounterSetTest.assertEquals((int)9, (int)this.counterSet.getTotal());
    }

    public void testContains() {
        CounterSetTest.assertTrue((boolean)this.counterSet.contains("test1"));
        CounterSetTest.assertTrue((boolean)this.counterSet.contains("test2"));
        CounterSetTest.assertFalse((boolean)this.counterSet.contains("X"));
    }

    public void testGetValue() {
        CounterSetTest.assertEquals((int)5, (int)this.counterSet.getValue("test1"));
        CounterSetTest.assertEquals((int)1, (int)this.counterSet.getValue("test2"));
        CounterSetTest.assertEquals((int)0, (int)this.counterSet.getValue("X"));
    }

    public void testGetElements() {
        UnmodifiableSet<String> elements = this.counterSet.getKeys();
        CounterSetTest.assertEquals((int)2, (int)elements.size());
        CounterSetTest.assertTrue((boolean)elements.contains("test1"));
        CounterSetTest.assertTrue((boolean)elements.contains("test2"));
    }

    public void testGetTotal() {
        CounterSetTest.assertEquals((int)6, (int)this.counterSet.getTotal());
    }
}

