/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.HashedListMap;

public class HashedListMapTest
extends TestCase {
    private HashedListMap<String, String> map;

    protected void setUp() {
        this.map = new HashedListMap();
        this.map.add("test1", "test1_0");
        this.map.add("test1", "test1_1");
        this.map.add("test2", "test2_0");
        this.map.add("test2", "test2_1");
        this.map.add("test2", "test2_2");
    }

    public void testCreateList() {
        List<String> list = this.map.createList("test");
        HashedListMapTest.assertEquals((int)0, (int)list.size());
        list = this.map.createList("test1");
        HashedListMapTest.assertEquals((int)0, (int)list.size());
    }

    public void testGetList() {
        List<String> list = this.map.getList("test2");
        HashedListMapTest.assertEquals((String)"test2_0", (String)list.get(0));
        HashedListMapTest.assertEquals((String)"test2_1", (String)list.get(1));
        HashedListMapTest.assertEquals((String)"test2_2", (String)list.get(2));
    }

    public void testAdd() {
        this.map.add("test1", "x");
        List<String> list = this.map.getList("test1");
        HashedListMapTest.assertEquals((String)"x", (String)list.get(2));
        this.map.add("test3", "x");
        list = this.map.getList("test3");
        HashedListMapTest.assertEquals((String)"x", (String)list.get(0));
    }

    public void testAddAll() {
        HashedListMap<String, String> other = new HashedListMap<String, String>();
        other.add("test1", "x");
        other.add("test3", "x");
        this.map.addAll(other);
        HashedListMapTest.assertEquals((String)"x", (String)this.map.getList("test1").get(2));
        HashedListMapTest.assertEquals((String)"x", (String)this.map.getList("test3").get(0));
    }

    public void testContainsList() {
        HashedListMapTest.assertTrue((boolean)this.map.containsList("test1"));
        HashedListMapTest.assertTrue((boolean)this.map.containsList("test2"));
        HashedListMapTest.assertFalse((boolean)this.map.containsList("test3"));
    }

    public void testRemoveList() {
        HashedListMapTest.assertTrue((boolean)this.map.containsList("test1"));
        this.map.removeList("test1");
        HashedListMapTest.assertFalse((boolean)this.map.containsList("test1"));
    }

    public void testRemoveAllLists() {
        HashedListMapTest.assertTrue((boolean)this.map.containsList("test1"));
        HashedListMapTest.assertTrue((boolean)this.map.containsList("test2"));
        this.map.removeAllLists(Arrays.asList("test1", "test2"));
        HashedListMapTest.assertFalse((boolean)this.map.containsList("test1"));
        HashedListMapTest.assertFalse((boolean)this.map.containsList("test2"));
    }

    public void testGetKeys() {
        Set<String> keys = this.map.getKeys();
        HashedListMapTest.assertEquals((int)2, (int)keys.size());
        HashedListMapTest.assertTrue((boolean)keys.contains("test1"));
        HashedListMapTest.assertTrue((boolean)keys.contains("test2"));
    }

    public void testGetValues() {
        List<String> values = this.map.getValues();
        HashedListMapTest.assertEquals((int)5, (int)values.size());
        HashedListMapTest.assertTrue((boolean)values.contains("test1_0"));
        HashedListMapTest.assertTrue((boolean)values.contains("test1_1"));
        HashedListMapTest.assertTrue((boolean)values.contains("test2_0"));
        HashedListMapTest.assertTrue((boolean)values.contains("test2_1"));
        HashedListMapTest.assertTrue((boolean)values.contains("test2_2"));
    }

    public void testAreAllListsEmpty() {
        HashedListMapTest.assertFalse((boolean)this.map.areAllListsEmpty());
        this.map.clear();
        HashedListMapTest.assertTrue((boolean)this.map.areAllListsEmpty());
        this.setUp();
        HashedListMapTest.assertFalse((boolean)this.map.areAllListsEmpty());
        for (String key : this.map.getKeys()) {
            this.map.getList(key).clear();
        }
        HashedListMapTest.assertTrue((boolean)this.map.areAllListsEmpty());
    }

    public void testListToArrays() {
        Map<String, String[]> arrayMap = this.map.listsToArrays(String.class);
        HashedListMapTest.assertTrue((arrayMap.keySet().size() == 2 ? 1 : 0) != 0);
        HashedListMapTest.assertTrue((arrayMap.get("test1").length == 2 ? 1 : 0) != 0);
        HashedListMapTest.assertTrue((arrayMap.get("test2").length == 3 ? 1 : 0) != 0);
    }
}

