/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.collections;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.conqat.lib.commons.collections.IdentityHashSet;

public class IdentityHashSetTest
extends TestCase {
    private final IdentityHashSet<Integer> testSet = new IdentityHashSet();

    public void testSize() {
        IdentityHashSetTest.assertEquals((int)0, (int)this.testSet.size());
        this.testSet.add(1);
        IdentityHashSetTest.assertEquals((int)1, (int)this.testSet.size());
    }

    public void testIsEmpty() {
        IdentityHashSetTest.assertTrue((boolean)this.testSet.isEmpty());
        this.testSet.add(1);
        IdentityHashSetTest.assertFalse((boolean)this.testSet.isEmpty());
    }

    public void testClear() {
        this.testSet.add(1);
        IdentityHashSetTest.assertFalse((boolean)this.testSet.isEmpty());
        this.testSet.clear();
        IdentityHashSetTest.assertTrue((boolean)this.testSet.isEmpty());
        IdentityHashSetTest.assertEquals((int)0, (int)this.testSet.size());
    }

    public void testConstructor() {
        ArrayList<Integer> testList = new ArrayList<Integer>();
        testList.add(1);
        testList.add(2);
        testList.add(3);
        IdentityHashSet set = new IdentityHashSet(testList);
        IdentityHashSetTest.assertEquals((int)3, (int)set.size());
    }

    public void testAdd() {
        this.testSet.add(1);
        IdentityHashSetTest.assertEquals((int)1, (int)this.testSet.size());
        IdentityHashSetTest.assertEquals((Object)1, (Object)this.testSet.iterator().next());
    }

    public void testClone() {
        this.testSet.add(1);
        Object clone = this.testSet.clone();
        IdentityHashSetTest.assertNotSame((Object)clone, this.testSet);
        IdentityHashSetTest.assertEquals((int)1, (int)((IdentityHashSet)clone).size());
        IdentityHashSetTest.assertEquals((Object)1, ((IdentityHashSet)clone).iterator().next());
    }

    public void testContains() {
        Integer one = new Integer(1);
        this.testSet.add(one);
        IdentityHashSetTest.assertEquals((int)1, (int)this.testSet.size());
        IdentityHashSetTest.assertTrue((boolean)this.testSet.contains(one));
        IdentityHashSetTest.assertFalse((boolean)this.testSet.contains(new Integer(1)));
    }

    public void testRemove() {
        Integer one = new Integer(1);
        this.testSet.add(one);
        IdentityHashSetTest.assertEquals((int)1, (int)this.testSet.size());
        this.testSet.remove(one);
        IdentityHashSetTest.assertEquals((int)0, (int)this.testSet.size());
        this.testSet.add(one);
        IdentityHashSetTest.assertEquals((int)1, (int)this.testSet.size());
        this.testSet.remove(new Integer(1));
        IdentityHashSetTest.assertEquals((int)1, (int)this.testSet.size());
    }
}

