/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import junit.framework.TestCase;
import org.conqat.lib.commons.constraint.ConstraintValidator;
import org.conqat.lib.commons.constraint.ConstraintViolationException;
import org.conqat.lib.commons.constraint.ILocalConstraint;
import org.conqat.lib.commons.error.CollectingExceptionHandler;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.visitor.VisitorUtilsTest;

public class ConstraintValidatorTest
extends TestCase {
    private ConstraintValidator validator;

    protected void setUp() {
        this.validator = new ConstraintValidator();
        this.validator.addConstraint(String.class, new ILocalConstraint<String>(){

            @Override
            public void checkLocalConstraint(String s) throws ConstraintViolationException {
                if (StringUtils.isEmpty(s)) {
                    throw new ConstraintViolationException("String must not be empty", s);
                }
            }
        });
        this.validator.addConstraint(Collection.class, new ILocalConstraint<Collection>(){

            @Override
            public void checkLocalConstraint(Collection c) throws ConstraintViolationException {
                if (c.isEmpty()) {
                    throw new ConstraintViolationException("Collection must not be empty", c);
                }
            }
        });
        this.validator.addConstraint(List.class, new ILocalConstraint<List>(){

            @Override
            public void checkLocalConstraint(List l) throws ConstraintViolationException {
                if (l.size() <= 1) {
                    throw new ConstraintViolationException("Lists must have more than 1 element", l);
                }
            }
        });
        this.validator.addConstraint(LinkedList.class, new ILocalConstraint<LinkedList>(){

            @Override
            public void checkLocalConstraint(LinkedList l) throws ConstraintViolationException {
                throw new ConstraintViolationException("Linked lists are disallowed", l);
            }
        });
    }

    public void testSimple() throws Exception {
        this.validator.checkConstaints("bla");
        try {
            this.validator.checkConstaints("");
            ConstraintValidatorTest.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testWithInheritance() throws Exception {
        HashSet<String> set = new HashSet<String>();
        try {
            this.validator.checkConstaints(set);
            ConstraintValidatorTest.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        set.add("r");
        this.validator.checkConstaints(set);
        ArrayList<String> l = new ArrayList<String>();
        l.add("foo");
        try {
            this.validator.checkConstaints(l);
            ConstraintValidatorTest.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        l.add("bar");
        this.validator.checkConstaints(l);
        LinkedList l2 = new LinkedList(l);
        try {
            this.validator.checkConstaints(l2);
            ConstraintValidatorTest.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public void testMeshed() {
        ArrayList root = new ArrayList();
        ArrayList ch1 = new ArrayList();
        ArrayList<Object> ch2 = new ArrayList<Object>();
        ArrayList<Object> ch3 = new ArrayList<Object>();
        root.add(ch1);
        root.add(ch2);
        ch2.add(ch3);
        ch2.add("a");
        ch2.add("b");
        ch2.add("c");
        ch3.add(root);
        ch3.add("");
        ch3.add("e");
        CollectingExceptionHandler<ConstraintViolationException> handler = new CollectingExceptionHandler<ConstraintViolationException>();
        this.validator.validateMesh(root, new VisitorUtilsTest.ListWalker(), handler);
        ConstraintValidatorTest.assertEquals((int)3, (int)handler.getExceptions().size());
    }
}

