/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.enums;

import org.conqat.lib.commons.assertion.CCSMAssert;

public class EnumUtils {
    public static <T extends Enum<T>> T valueOf(Class<T> enumType, String constantName) {
        try {
            T constant = Enum.valueOf(enumType, constantName);
            return constant;
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <T extends Enum<T>> T valueOfIgnoreCase(Class<T> enumType, String constantName) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        Enum[] enumArray = constants;
        int n = constants.length;
        int n2 = 0;
        while (n2 < n) {
            Enum constant = enumArray[n2];
            if (constant.name().equalsIgnoreCase(constantName)) {
                return (T)constant;
            }
            ++n2;
        }
        return null;
    }

    public static <T extends Enum<T>> String[] stringValues(Class<T> enumType) {
        Enum[] constants = (Enum[])enumType.getEnumConstants();
        CCSMAssert.isNotNull(constants);
        String[] result = new String[constants.length];
        int i = 0;
        while (i < constants.length) {
            result[i] = constants[i].name();
            ++i;
        }
        return result;
    }
}

