/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.collections.BasicPatternList;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AntPatternDirectoryScanner {
    private final File baseDir;
    private final boolean caseSensitive;
    private final List<String> filesFound = new ArrayList<String>();
    private final BasicPatternList fileIncludes = new BasicPatternList();
    private final BasicPatternList fileExcludes = new BasicPatternList();
    private final BasicPatternList greedyExcludes = new BasicPatternList();
    private final String[] requiredPrefixes;

    private AntPatternDirectoryScanner(File baseDir, boolean caseSensitive, String[] includePatterns, String[] excludePatterns) throws PatternSyntaxException {
        CCSMPre.isTrue(baseDir.isDirectory(), "Can only scan in directories: " + baseDir);
        this.baseDir = baseDir;
        this.caseSensitive = caseSensitive;
        boolean hadStarPrefix = false;
        ArrayList<String> prefixes = new ArrayList<String>();
        String[] stringArray = includePatterns;
        int n = includePatterns.length;
        int n2 = 0;
        while (n2 < n) {
            String include = stringArray[n2];
            this.fileIncludes.add(AntPatternUtils.convertPattern(include, caseSensitive));
            if (include.startsWith("*")) {
                hadStarPrefix = true;
            } else {
                String prefix = include.replaceFirst("([\\*/\\?]|" + Pattern.quote(File.separator) + ").*$", "");
                if (!caseSensitive) {
                    prefix = prefix.toLowerCase();
                }
                prefixes.add(prefix);
            }
            ++n2;
        }
        this.requiredPrefixes = hadStarPrefix || prefixes.isEmpty() ? null : prefixes.toArray(new String[prefixes.size()]);
        stringArray = excludePatterns;
        n = excludePatterns.length;
        n2 = 0;
        while (n2 < n) {
            String exclude = stringArray[n2];
            Pattern pattern = AntPatternUtils.convertPattern(exclude, caseSensitive);
            this.fileExcludes.add(pattern);
            if (exclude.endsWith("**")) {
                this.greedyExcludes.add(pattern);
            }
            ++n2;
        }
    }

    private String[] scan() throws IOException {
        String[] stringArray = this.listChildren(this.baseDir);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            String testPath = path = stringArray[n2];
            if (!this.caseSensitive) {
                testPath = testPath.toLowerCase();
            }
            if (this.requiredPrefixes == null || StringUtils.startsWithOneOf(testPath, this.requiredPrefixes)) {
                this.doScan(path);
            }
            ++n2;
        }
        return this.filesFound.toArray(new String[this.filesFound.size()]);
    }

    private void doScan(String relativePath) throws IOException {
        File file = new File(this.baseDir, relativePath);
        if (file.isDirectory()) {
            if (!this.skipDirectory(relativePath)) {
                String[] stringArray = this.listChildren(file);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    this.doScan(String.valueOf(relativePath) + "/" + name);
                    ++n2;
                }
            }
        } else if (this.isIncluded(relativePath) && !this.isExcluded(relativePath)) {
            this.filesFound.add(relativePath.replace('/', File.separatorChar));
        }
    }

    private String[] listChildren(File dir) throws IOException {
        String[] list = dir.list();
        if (list == null) {
            throw new IOException("Cannot scan in directory " + dir + "! Maybe read permissions are missing?");
        }
        return list;
    }

    private boolean skipDirectory(String relativePath) {
        return this.greedyExcludes.matchesAny(relativePath);
    }

    private boolean isIncluded(String relativePath) {
        return this.fileIncludes.isEmpty() || this.fileIncludes.matchesAny(relativePath);
    }

    private boolean isExcluded(String relativePath) {
        return this.fileExcludes.matchesAny(relativePath);
    }

    public static String[] scan(String baseDir, boolean caseSensitive, String[] includePatterns, String[] excludePatterns) throws IOException {
        if (includePatterns == null) {
            includePatterns = new String[]{};
        }
        if (excludePatterns == null) {
            excludePatterns = new String[]{};
        }
        return new AntPatternDirectoryScanner(new File(baseDir), caseSensitive, includePatterns, excludePatterns).scan();
    }
}

