/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.TreeSet;
import org.conqat.lib.commons.filesystem.AntPatternDirectoryScanner;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class AntPatternDirectoryScannerTest
extends CCSMTestCaseBase {
    private String testDirectory;

    public void setUp() throws IOException {
        File testDirectory = new File(this.getTmpDirectory(), "directory_scanner");
        this.testDirectory = testDirectory.getPath();
        FileSystemUtils.writeFile(new File(testDirectory, "alpha/beta/gamma/gamma.xml"), "gamma");
        FileSystemUtils.writeFile(new File(testDirectory, "alpha/beta/beta.xml"), "beta");
    }

    private void extendedSetup() throws IOException {
        FileSystemUtils.writeFile(new File(this.testDirectory, "delta/delta.xml"), "delta");
    }

    public void tearDown() {
        File testDirectory = new File(this.testDirectory);
        FileSystemUtils.deleteRecursively(testDirectory);
        AntPatternDirectoryScannerTest.assertFalse((boolean)testDirectory.exists());
    }

    public void test1() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha"}, null);
        this.compareFiles(files, new String[0]);
    }

    public void test2() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"});
    }

    public void test3() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, null, null);
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"});
    }

    public void testFullPathMatchesCaseSensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/beta/gamma/GAMMA.XML"}, null);
        this.compareFiles(files, new String[0]);
    }

    public void testFullPathMatchesCaseInsensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, false, new String[]{"alpha/beta/gamma/GAMMA.XML"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/gamma/gamma.xml"});
    }

    public void test2ButCaseInsensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, false, new String[]{"ALPHA/"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"});
    }

    public void testOrderOfIncludePatternsIrrelevant() throws IOException {
        String[] expectedFiles = new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"};
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/be?a/**", "alpha/beta/gamma/"}, null);
        this.compareFiles(files, expectedFiles);
        files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/beta/gamma/", "alpha/be?a/**"}, null);
        this.compareFiles(files, expectedFiles);
    }

    public void testPatternsDifferInCaseScanningSensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/", "ALPHA/"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"});
    }

    public void testPatternsDifferInCaseScanningInsensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, false, new String[]{"alpha/", "ALPHA/"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"});
    }

    public void testFullpathDiffersInCaseScanningSensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/beta/gamma/gamma.xml", "alpha/beta/gamma/GAMMA.XML"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/gamma/gamma.xml"});
    }

    public void testFullpathDiffersInCaseScanningInsensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, false, new String[]{"alpha/beta/gamma/gamma.xml", "alpha/beta/gamma/GAMMA.XML"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/gamma/gamma.xml"});
    }

    public void testParentDiffersInCaseScanningSensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/", "ALPHA/beta/"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"});
    }

    public void testParentDiffersInCaseScanningInsensitive() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, false, new String[]{"alpha/", "ALPHA/beta/"}, null);
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml"});
    }

    public void testExcludeOneFile() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"**/*.xml"}, new String[]{"alpha/beta/b*xml"});
        this.compareFiles(files, new String[]{"alpha/beta/gamma/gamma.xml"});
    }

    public void testExcludeHasPrecedence() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/**"}, new String[]{"alpha/**"});
        this.compareFiles(files, new String[0]);
    }

    public void testAlternateIncludeExclude() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/**", "alpha/beta/gamma/**"}, new String[]{"alpha/beta/**"});
        this.compareFiles(files, new String[0]);
    }

    public void testAlternateExcludeInclude() throws IOException {
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"alpha/beta/**"}, new String[]{"alpha/**", "alpha/beta/gamma/**"});
        this.compareFiles(files, new String[0]);
    }

    public void testChildrenOfExcludedDirectory() throws IOException, IOException {
        this.extendedSetup();
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, null, new String[]{"alpha/**"});
        this.compareFiles(files, new String[]{"delta/delta.xml"});
        files = AntPatternDirectoryScanner.scan(this.testDirectory, true, null, new String[]{"alpha"});
        this.compareFiles(files, new String[]{"alpha/beta/beta.xml", "alpha/beta/gamma/gamma.xml", "delta/delta.xml"});
    }

    public void testCommonPrefix() throws IOException, IOException {
        FileSystemUtils.writeFile(new File(this.testDirectory, "alpha/beta2/beta.xml"), "beta");
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, null, new String[]{"**/beta/**"});
        this.compareFiles(files, new String[]{"alpha/beta2/beta.xml"});
    }

    public void testDoubleStarStart() throws IOException, IOException {
        FileSystemUtils.writeFile(new File(this.testDirectory, "foo.java"), "foo");
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"**/*.java"}, null);
        this.compareFiles(files, new String[]{"foo.java"});
    }

    public void testDoubleStarMiddle() throws IOException, IOException {
        this.extendedSetup();
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"delta/**/*.xml"}, null);
        this.compareFiles(files, new String[]{"delta/delta.xml"});
    }

    public void testOnlyExtension() throws IOException, IOException {
        FileSystemUtils.writeFile(new File(this.testDirectory, "delta/.xml"), "xml");
        String[] files = AntPatternDirectoryScanner.scan(this.testDirectory, true, new String[]{"**/.xml"}, null);
        this.compareFiles(files, new String[]{"delta/.xml"});
    }

    private void compareFiles(String[] includedFiles, String[] expectedFiles) {
        AntPatternDirectoryScannerTest.assertEquals((String)"file present: ", (int)expectedFiles.length, (int)includedFiles.length);
        TreeSet<String> files = new TreeSet<String>();
        int counter = 0;
        while (counter < includedFiles.length) {
            files.add(includedFiles[counter].replace(File.separatorChar, '/'));
            ++counter;
        }
        Iterator i = files.iterator();
        int counter2 = 0;
        while (i.hasNext()) {
            String currentfile = (String)i.next();
            AntPatternDirectoryScannerTest.assertEquals((String)expectedFiles[counter2], (String)currentfile);
            ++counter2;
        }
    }
}

