/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class AntPatternUtils {
    public static Pattern convertPattern(String antPattern, boolean caseSensitive) throws PatternSyntaxException {
        if ((antPattern = FileSystemUtils.normalizeSeparators(antPattern)).endsWith("/")) {
            antPattern = String.valueOf(antPattern) + "**";
        }
        StringBuilder patternBuilder = new StringBuilder();
        boolean addTrailAll = false;
        if (antPattern.endsWith("/**")) {
            addTrailAll = true;
            antPattern = StringUtils.stripSuffix("/**", antPattern);
        }
        AntPatternUtils.convertPlainPattern(antPattern, patternBuilder);
        if (addTrailAll) {
            patternBuilder.append("(/.*)?");
        }
        int flags = 32;
        if (!caseSensitive) {
            flags |= 2;
        }
        try {
            return Pattern.compile(patternBuilder.toString(), flags);
        }
        catch (PatternSyntaxException e) {
            throw new PatternSyntaxException("Error compiling ANT pattern '" + antPattern + "' to regular expression. " + e.getDescription(), e.getPattern(), e.getIndex());
        }
    }

    private static void convertPlainPattern(String antPattern, StringBuilder patternBuilder) {
        int i = 0;
        while (i < antPattern.length()) {
            char c = antPattern.charAt(i);
            if (c == '?') {
                patternBuilder.append("[^/]");
            } else if (c != '*') {
                patternBuilder.append(Pattern.quote(Character.toString(c)));
            } else {
                boolean doubleStar = AntPatternUtils.lookAhead(antPattern, i + 1, '*');
                if (doubleStar) {
                    if (AntPatternUtils.lookAhead(antPattern, i + 2, '/')) {
                        patternBuilder.append("(.*/)?");
                        i += 2;
                    } else {
                        patternBuilder.append(".*");
                        ++i;
                    }
                } else {
                    patternBuilder.append("[^/]*");
                }
            }
            ++i;
        }
    }

    private static boolean lookAhead(String s, int position, char character) {
        return position < s.length() && s.charAt(position) == character;
    }
}

