/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.IOException;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public class CanonicalFileTest
extends CCSMTestCaseBase {
    public void test() throws IOException {
        File plainFile = this.useTestFile("canonical.txt");
        CanonicalFile canonicalFile = new CanonicalFile(plainFile);
        CanonicalFileTest.assertFalse((boolean)plainFile.equals(canonicalFile));
        CanonicalFileTest.assertEquals((Object)plainFile.getCanonicalFile(), (Object)canonicalFile);
        CanonicalFileTest.assertEquals((String)plainFile.getCanonicalPath(), (String)canonicalFile.getPath());
        CanonicalFileTest.assertEquals((String)plainFile.getCanonicalPath(), (String)canonicalFile.getAbsolutePath());
        CanonicalFileTest.assertEquals((String)plainFile.getCanonicalPath(), (String)canonicalFile.getCanonicalPath());
        CanonicalFileTest.assertFalse((boolean)new CanonicalFile("c:/x/../z", "../x/y").getCanonicalPath().contains(".."));
    }

    public void testException() {
        try {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < 100000) {
                sb.append("/test");
                ++i;
            }
            new CanonicalFile("c:/.../text.txt" + sb.toString());
            CanonicalFileTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void testEmptyParent() throws IOException {
        CanonicalFile file = new CanonicalFile(File.listRoots()[0]);
        CanonicalFileTest.assertNull((Object)file.getParentFile());
    }
}

