/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class ClassPathUtils {
    public static String createClassPathAsString(IURLResolver resolver, Class<?> ... anchorClasses) throws IOException {
        return StringUtils.concat(ClassPathUtils.createClassPathAsSet(resolver, anchorClasses), File.pathSeparator);
    }

    public static String[] createClassPathAsArray(IURLResolver resolver, Class<?> ... anchorClasses) throws IOException {
        return ClassPathUtils.createClassPathAsSet(resolver, anchorClasses).toArray(new String[0]);
    }

    public static LinkedHashSet<String> createClassPathAsSet(IURLResolver resolver, Class<?> ... anchorClasses) throws IOException {
        LinkedHashSet<String> classPath = new LinkedHashSet<String>();
        Class<?>[] classArray = anchorClasses;
        int n = anchorClasses.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> clazz = classArray[n2];
            classPath.add(ClassPathUtils.createClassPath(resolver, clazz));
            ++n2;
        }
        return classPath;
    }

    public static String createClassPath(IURLResolver resolver, Class<?> anchorClass) throws IOException {
        String protocol;
        URL url = ClassPathUtils.obtainClassFileURL(anchorClass);
        if (url == null) {
            throw new AssertionError((Object)"Internal assumption violated.");
        }
        if (resolver != null) {
            url = resolver.resolve(url);
        }
        if ("file".equals(protocol = url.getProtocol())) {
            return ClassPathUtils.createFileClasspath(url, anchorClass);
        }
        if ("jar".equals(protocol)) {
            return FileSystemUtils.extractJarFileFromJarURL(url).getCanonicalPath();
        }
        throw new IOException("Unsupported protocol: " + protocol);
    }

    public static URL obtainClassFileURL(Class<?> clazz) {
        return clazz.getResource(String.valueOf(clazz.getSimpleName()) + ".class");
    }

    private static String createFileClasspath(URL url, Class<?> clazz) throws IOException {
        String path = url.getPath();
        path = path.substring(0, path.length() - 6 - clazz.getName().length());
        return new File(path).getCanonicalPath();
    }

    public static interface IURLResolver {
        public URL resolve(URL var1) throws IOException;
    }
}

