/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.util.Arrays;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.ArrayUtils;

public final class EByteOrderMark
extends Enum<EByteOrderMark> {
    public static final /* enum */ EByteOrderMark UTF_32BE;
    public static final /* enum */ EByteOrderMark UTF_32LE;
    public static final /* enum */ EByteOrderMark UTF_16BE;
    public static final /* enum */ EByteOrderMark UTF_16LE;
    public static final /* enum */ EByteOrderMark UTF_8_BOM;
    public static final int MAX_BOM_LENGTH = 4;
    private final String encoding;
    private final byte[] bom;
    private static final /* synthetic */ EByteOrderMark[] ENUM$VALUES;

    static {
        byte[] byArray = new byte[4];
        byArray[2] = -2;
        byArray[3] = -1;
        UTF_32BE = new EByteOrderMark("UTF-32BE", byArray);
        byte[] byArray2 = new byte[4];
        byArray2[0] = -1;
        byArray2[1] = -2;
        UTF_32LE = new EByteOrderMark("UTF-32LE", byArray2);
        UTF_16BE = new EByteOrderMark("UTF-16BE", new byte[]{-2, -1});
        UTF_16LE = new EByteOrderMark("UTF-16LE", new byte[]{-1, -2});
        UTF_8_BOM = new EByteOrderMark("UTF-8", new byte[]{-17, -69, -65});
        ENUM$VALUES = new EByteOrderMark[]{UTF_32BE, UTF_32LE, UTF_16BE, UTF_16LE, UTF_8_BOM};
    }

    private EByteOrderMark(String encoding, byte[] bom) {
        this.encoding = encoding;
        CCSMAssert.isTrue(bom.length <= 4, "Inconsistent max BOM length!");
        this.bom = bom;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public byte[] getBOM() {
        return Arrays.copyOf(this.bom, this.bom.length);
    }

    public int getBOMLength() {
        return this.bom.length;
    }

    public static EByteOrderMark determineBOM(byte[] data) {
        EByteOrderMark[] eByteOrderMarkArray = EByteOrderMark.values();
        int n = eByteOrderMarkArray.length;
        int n2 = 0;
        while (n2 < n) {
            EByteOrderMark bom = eByteOrderMarkArray[n2];
            if (ArrayUtils.isPrefix(bom.bom, data)) {
                return bom;
            }
            ++n2;
        }
        return null;
    }

    public static EByteOrderMark[] values() {
        EByteOrderMark[] eByteOrderMarkArray = ENUM$VALUES;
        int n = eByteOrderMarkArray.length;
        EByteOrderMark[] eByteOrderMarkArray2 = new EByteOrderMark[n];
        System.arraycopy(ENUM$VALUES, 0, eByteOrderMarkArray2, 0, n);
        return eByteOrderMarkArray2;
    }

    public static EByteOrderMark valueOf(String string) {
        return Enum.valueOf(EByteOrderMark.class, string);
    }
}

