/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.filesystem;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.PathBasedContentProviderBase;
import org.conqat.lib.commons.test.CCSMTestCaseBase;

public abstract class PathBasedContentProviderBaseTestBase
extends CCSMTestCaseBase {
    private PathBasedContentProviderBase provider;

    protected void setUp() throws Exception {
        this.provider = this.openProvider();
    }

    protected void tearDown() throws Exception {
        this.provider.close();
    }

    public void testListFiles() throws IOException {
        String[] expected = new String[]{"a.txt", "b/g.txt", "c/d/e.txt", "c/d/f.txt"};
        Collection<String> actual = this.filterSVN(this.provider.getPaths());
        PathBasedContentProviderBaseTestBase.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet<String>(actual));
    }

    public void testListWithPrefix() throws IOException {
        String[] expected = new String[]{"c/d/e.txt", "c/d/f.txt"};
        Collection<String> actual = this.filterSVN(this.provider.getPathsWithPrefix("c/d"));
        PathBasedContentProviderBaseTestBase.assertEquals(new HashSet<String>(Arrays.asList(expected)), new HashSet<String>(actual));
    }

    private Collection<String> filterSVN(Collection<String> paths) {
        ArrayList<String> result = new ArrayList<String>();
        for (String path : paths) {
            if (path.contains(".svn")) continue;
            result.add(path);
        }
        return result;
    }

    public void testContentAccess() throws IOException {
        InputStream in = this.provider.openStream("c/d/f.txt");
        String content = FileSystemUtils.readStream(in);
        in.close();
        PathBasedContentProviderBaseTestBase.assertEquals((String)"fgh", (String)content);
    }

    protected abstract PathBasedContentProviderBase openProvider() throws IOException;
}

