/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.graph;

import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import junit.framework.TestCase;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.graph.EGraphvizOutputFormat;
import org.conqat.lib.commons.graph.GraphvizException;
import org.conqat.lib.commons.graph.GraphvizGenerator;
import org.conqat.lib.commons.string.StringUtils;

public class GraphvizGeneratorTest
extends TestCase {
    private static final String ERR_TEST_DESCRIPTION = "digraph G { A -> B;   C -> /*; B -> E}";
    private static final String TEST_DESCRIPTION = "digraph G { A -> B;   C -> B; B -> E}";
    private static final String UNKNOWN_FONT_DESCRIPTION = "digraph G { node[fontname=\"unknownFont\"]; A -> B;   C -> B; B -> E}";
    private final GraphvizGenerator generator = new GraphvizGenerator();

    public static void main(String[] args) throws HeadlessException, IOException, GraphvizException {
        GraphvizGenerator generator = new GraphvizGenerator();
        BufferedImage image = generator.generateImage(TEST_DESCRIPTION);
        JFrame frame = new JFrame("GraphvizGeneratorTest");
        frame.setDefaultCloseOperation(3);
        JLabel label = new JLabel(new ImageIcon(image));
        frame.getContentPane().add(label);
        frame.pack();
        frame.setVisible(true);
    }

    public void testGenerateFileWithBigDescription() throws IOException, GraphvizException {
        File file = new File("test-tmp/test.png");
        FileSystemUtils.ensureParentDirectoryExists(file);
        String description = this.createDescription("");
        this.generator.generateFile(description, file, EGraphvizOutputFormat.PNG);
        GraphvizGeneratorTest.assertTrue((boolean)file.exists());
        GraphvizGeneratorTest.assertTrue((file.length() > 0L ? 1 : 0) != 0);
        file.delete();
    }

    public void testGenerateImageWithBigDescription() throws IOException, GraphvizException {
        String description = this.createDescription("");
        BufferedImage image = this.generator.generateImage(description);
        GraphvizGeneratorTest.assertNotNull((Object)image);
        GraphvizGeneratorTest.assertTrue((image.getWidth() > 0 ? 1 : 0) != 0);
        GraphvizGeneratorTest.assertTrue((image.getHeight() > 0 ? 1 : 0) != 0);
    }

    public void testGenerateFileBigDescriptionWithWarnings() throws IOException, GraphvizException {
        File file = new File("test-tmp/test.png");
        FileSystemUtils.ensureParentDirectoryExists(file);
        String description = this.createDescription(":");
        this.generator.generateFile(description, file, EGraphvizOutputFormat.PNG);
        GraphvizGeneratorTest.assertTrue((boolean)file.exists());
        GraphvizGeneratorTest.assertTrue((file.length() > 0L ? 1 : 0) != 0);
        file.delete();
    }

    public void testGenerateImageWithBigDescriptionWithWarnings() throws IOException, GraphvizException {
        String description = this.createDescription(":");
        BufferedImage image = this.generator.generateImage(description);
        GraphvizGeneratorTest.assertNotNull((Object)image);
        GraphvizGeneratorTest.assertTrue((image.getWidth() > 0 ? 1 : 0) != 0);
        GraphvizGeneratorTest.assertTrue((image.getHeight() > 0 ? 1 : 0) != 0);
    }

    public void testGenerateFile() throws IOException, GraphvizException {
        File file = new File("test-tmp/test1.png");
        FileSystemUtils.ensureParentDirectoryExists(file);
        this.generator.generateFile(TEST_DESCRIPTION, file, EGraphvizOutputFormat.PNG);
        GraphvizGeneratorTest.assertTrue((boolean)file.exists());
        GraphvizGeneratorTest.assertTrue((file.length() > 0L ? 1 : 0) != 0);
        file.delete();
    }

    public void testGenerateFileError() throws IOException {
        File file = new File("test-tmp/test1.png");
        FileSystemUtils.ensureParentDirectoryExists(file);
        try {
            this.generator.generateFile(ERR_TEST_DESCRIPTION, file, EGraphvizOutputFormat.PNG);
        }
        catch (GraphvizException e) {
            file.delete();
            return;
        }
        GraphvizGeneratorTest.fail((String)"Should create exception");
    }

    public void testGenerateFileUnknownFont() throws IOException, GraphvizException {
        File file = new File("test-tmp/test1.png");
        FileSystemUtils.ensureParentDirectoryExists(file);
        this.generator.generateFile(UNKNOWN_FONT_DESCRIPTION, file, EGraphvizOutputFormat.PNG);
        GraphvizGeneratorTest.assertTrue((boolean)file.exists());
        GraphvizGeneratorTest.assertTrue((file.length() > 0L ? 1 : 0) != 0);
        file.delete();
    }

    public void testGenerateImage() throws IOException, GraphvizException {
        BufferedImage image = this.generator.generateImage(TEST_DESCRIPTION);
        GraphvizGeneratorTest.assertNotNull((Object)image);
        GraphvizGeneratorTest.assertTrue((image.getWidth() > 0 ? 1 : 0) != 0);
        GraphvizGeneratorTest.assertTrue((image.getHeight() > 0 ? 1 : 0) != 0);
    }

    public void testGenerateImageError() throws IOException {
        try {
            this.generator.generateImage(ERR_TEST_DESCRIPTION);
        }
        catch (GraphvizException e) {
            return;
        }
        GraphvizGeneratorTest.fail((String)"Should create exception");
    }

    public void testGenerateImageUnknownFont() throws IOException, GraphvizException {
        BufferedImage image = this.generator.generateImage(UNKNOWN_FONT_DESCRIPTION);
        GraphvizGeneratorTest.assertNotNull((Object)image);
        GraphvizGeneratorTest.assertTrue((image.getWidth() > 0 ? 1 : 0) != 0);
        GraphvizGeneratorTest.assertTrue((image.getHeight() > 0 ? 1 : 0) != 0);
    }

    private String createDescription(String prefix) {
        StringBuilder description = new StringBuilder();
        description.append("digraph G {");
        int i = 0;
        while (i < 100) {
            description.append("A");
            description.append(prefix);
            description.append(i);
            description.append(" -> ");
            description.append("B");
            description.append(i);
            description.append(";");
            description.append(StringUtils.CR);
            ++i;
        }
        description.append("}");
        return description.toString();
    }
}

