/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class MultiplexedOutputStream
extends OutputStream {
    private final OutputStream[] streams;

    public MultiplexedOutputStream(OutputStream ... streams) {
        this.streams = streams;
    }

    @Override
    public void close() throws MultiIOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            try {
                stream.close();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            ++n2;
        }
        this.checkExceptions(exceptions);
    }

    @Override
    public void flush() throws MultiIOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            try {
                stream.flush();
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            ++n2;
        }
        this.checkExceptions(exceptions);
    }

    @Override
    public void write(int b) throws MultiIOException {
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream stream = outputStreamArray[n2];
            try {
                stream.write(b);
            }
            catch (IOException e) {
                exceptions.add(e);
            }
            ++n2;
        }
        this.checkExceptions(exceptions);
    }

    private void checkExceptions(Collection<IOException> exceptions) throws MultiIOException {
        if (!exceptions.isEmpty()) {
            throw new MultiIOException(exceptions);
        }
    }

    public static class MultiIOException
    extends IOException {
        private final List<IOException> exceptions = new ArrayList<IOException>();

        public MultiIOException(Collection<? extends IOException> exceptions) {
            CCSMPre.isFalse(exceptions.isEmpty(), "Must have at least one exception.");
            this.exceptions.addAll(exceptions);
        }

        @Override
        public String getMessage() {
            StringBuilder result = new StringBuilder();
            for (IOException ex : this.exceptions) {
                result.append(ex.getMessage());
                result.append(StringUtils.CR);
            }
            return result.toString();
        }

        public UnmodifiableList<IOException> getExceptions() {
            return CollectionUtils.asUnmodifiable(this.exceptions);
        }
    }
}

