/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.MultiplexedOutputStream;

public class MultiplexedOutputStreamTest
extends TestCase {
    private final File file1 = new File("test-tmp/stream1.txt");
    private final File file2 = new File("test-tmp/stream2.txt");
    private FileOutputStream stream1;
    private FileOutputStream stream2;
    private MultiplexedOutputStream multiplexedStream;

    public void setUp() throws IOException {
        FileSystemUtils.ensureParentDirectoryExists(this.file1);
        this.stream1 = new FileOutputStream(this.file1);
        this.stream2 = new FileOutputStream(this.file2);
        this.multiplexedStream = new MultiplexedOutputStream(this.stream1, this.stream2);
    }

    public void testWrite() throws IOException {
        byte[] testArray = "This is a test".getBytes();
        this.multiplexedStream.write(testArray);
        this.multiplexedStream.close();
        String file1Content = FileSystemUtils.readFile(this.file1);
        String file2Content = FileSystemUtils.readFile(this.file2);
        MultiplexedOutputStreamTest.assertEquals((String)file1Content, (String)file2Content);
    }

    public void testClose() throws IOException {
        byte[] testArray = "This is a test".getBytes();
        this.multiplexedStream.close();
        try {
            this.stream1.write(testArray);
            MultiplexedOutputStreamTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.stream2.write(testArray);
            MultiplexedOutputStreamTest.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void tearDown() {
        this.file1.delete();
        this.file2.delete();
    }
}

