/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class StreamReaderThread
extends Thread {
    private final InputStream input;
    private StringBuilder content;

    public StreamReaderThread(InputStream input) {
        this.input = input;
        this.start();
    }

    @Override
    public synchronized void run() {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.input));
        char[] buffer = new char[1024];
        this.content = new StringBuilder();
        try {
            int read = 0;
            while ((read = reader.read(buffer)) != -1) {
                this.content.append(buffer, 0, read);
            }
        }
        catch (IOException e) {
            this.content.append(e);
        }
    }

    public synchronized String getContent() {
        return this.content.toString();
    }
}

