/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.TestCase;
import org.conqat.lib.commons.math.MathUtils;

public class MathUtilsTest
extends TestCase {
    private final Integer[] testValueArray = new Integer[]{1, 7, 9, 29, 31};
    private final Integer[] percentileValueArray = new Integer[]{6, 47, 49, 15, 42, 41, 7, 39, 43, 40, 36};

    public void testSum() {
        MathUtilsTest.assertEquals((Object)77.0, (Object)MathUtils.sum(Arrays.asList(this.testValueArray)));
    }

    public void testMax() {
        MathUtilsTest.assertEquals((Object)31.0, (Object)MathUtils.max(Arrays.asList(this.testValueArray)));
    }

    public void testMin() {
        MathUtilsTest.assertEquals((Object)1.0, (Object)MathUtils.min(Arrays.asList(this.testValueArray)));
    }

    public void testMean() {
        MathUtilsTest.assertEquals((Object)15.4, (Object)MathUtils.mean(Arrays.asList(this.testValueArray)));
    }

    public void testMedian() {
        MathUtilsTest.assertEquals((Object)9.0, (Object)MathUtils.median(Arrays.asList(this.testValueArray)));
        ArrayList<Integer> testValues = new ArrayList<Integer>(Arrays.asList(this.testValueArray));
        testValues.remove(0);
        MathUtilsTest.assertEquals((Object)9.0, (Object)MathUtils.median(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(this.testValueArray));
        testValues.remove(4);
        MathUtilsTest.assertEquals((Object)7.0, (Object)MathUtils.median(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(this.testValueArray));
        testValues.add(35);
        MathUtilsTest.assertEquals((Object)9.0, (Object)MathUtils.median(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(1, 2));
        MathUtilsTest.assertEquals((Object)1.0, (Object)MathUtils.median(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(1));
        MathUtilsTest.assertEquals((Object)1.0, (Object)MathUtils.median(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(new Integer[0]));
        MathUtilsTest.assertEquals((Object)Double.NaN, (Object)MathUtils.median(testValues));
    }

    public void testPercentile() {
        MathUtilsTest.assertEquals((Object)15.0, (Object)MathUtils.percentile25(Arrays.asList(this.percentileValueArray)));
        MathUtilsTest.assertEquals((Object)40.0, (Object)MathUtils.median(Arrays.asList(this.percentileValueArray)));
        MathUtilsTest.assertEquals((Object)43.0, (Object)MathUtils.percentile75(Arrays.asList(this.percentileValueArray)));
        ArrayList<Integer> testValues = new ArrayList<Integer>(Arrays.asList(1, 2));
        MathUtilsTest.assertEquals((Object)1.0, (Object)MathUtils.percentile25(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(1));
        MathUtilsTest.assertEquals((Object)1.0, (Object)MathUtils.percentile25(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
        MathUtilsTest.assertEquals((Object)1.0, (Object)MathUtils.percentile25(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(1, 2, 3, 4));
        MathUtilsTest.assertEquals((Object)1.0, (Object)MathUtils.percentile25(testValues));
        testValues = new ArrayList<Integer>(Arrays.asList(new Integer[0]));
        MathUtilsTest.assertEquals((Object)Double.NaN, (Object)MathUtils.percentile25(testValues));
    }

    public void testFactorial() {
        MathUtilsTest.assertEquals((long)1L, (long)MathUtils.factorial(-1));
        MathUtilsTest.assertEquals((long)1L, (long)MathUtils.factorial(0));
        MathUtilsTest.assertEquals((long)1L, (long)MathUtils.factorial(1));
        MathUtilsTest.assertEquals((long)2L, (long)MathUtils.factorial(2));
        MathUtilsTest.assertEquals((long)120L, (long)MathUtils.factorial(5));
    }
}

