/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.math.IAggregator;

public class PercentileAggregator
implements IAggregator {
    private final double percentile;

    public PercentileAggregator(double percentile) {
        CCSMAssert.isTrue(percentile > 0.0 && percentile <= 100.0, "Percentile must be in the range ]0, 100].");
        this.percentile = percentile;
    }

    @Override
    public double aggregate(Collection<? extends Number> values) {
        if (values.isEmpty()) {
            return Double.NaN;
        }
        ArrayList<Double> doubleValues = new ArrayList<Double>();
        for (Number number : values) {
            doubleValues.add(number.doubleValue());
        }
        Collections.sort(doubleValues);
        double d = (double)doubleValues.size() * this.percentile / 100.0;
        return (Double)doubleValues.get((int)Math.ceil(d) - 1);
    }

    @Override
    public double getNeutralElement() {
        return Double.NaN;
    }
}

