/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.math;

import junit.framework.TestCase;
import org.conqat.lib.commons.math.Range;

public class RangeTest
extends TestCase {
    public void testRangeWithSingleInt() {
        RangeTest.assertTrue((boolean)new Range(3.0, true, 3.0, true).contains(3.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 3.0, false).contains(3.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 3.0, true).contains(3.5));
    }

    public void testEmptyRange() {
        RangeTest.assertFalse((boolean)new Range(4.0, true, 3.0, true).contains(3.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 3.0, true).contains(3.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 3.0, false).contains(3.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 3.0, false).contains(3.5));
    }

    public void testIsEmpty() {
        RangeTest.assertTrue((boolean)new Range(4.0, true, 3.0, true).isEmpty());
        RangeTest.assertTrue((boolean)new Range(4.0, true, 3.0, false).isEmpty());
        RangeTest.assertTrue((boolean)new Range(4.0, false, 3.0, true).isEmpty());
        RangeTest.assertTrue((boolean)new Range(4.0, false, 3.0, false).isEmpty());
        RangeTest.assertTrue((boolean)new Range(3.0, false, 3.0, true).isEmpty());
        RangeTest.assertTrue((boolean)new Range(3.0, false, 3.0, false).isEmpty());
        RangeTest.assertTrue((boolean)new Range(3.0, true, 3.0, false).isEmpty());
        RangeTest.assertFalse((boolean)new Range(1.0, true, 2.0, true).isEmpty());
    }

    public void testInt() {
        RangeTest.assertTrue((boolean)new Range(3.0, true, 7.0, true).contains(4.0));
        RangeTest.assertTrue((boolean)new Range(3.0, true, 7.0, true).contains(3.0));
        RangeTest.assertTrue((boolean)new Range(3.0, true, 7.0, true).contains(7.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 7.0, true).contains(2.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 7.0, true).contains(8.0));
        RangeTest.assertTrue((boolean)new Range(3.0, true, 7.0, false).contains(4.0));
        RangeTest.assertTrue((boolean)new Range(3.0, true, 7.0, false).contains(3.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 7.0, false).contains(7.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 7.0, false).contains(2.0));
        RangeTest.assertFalse((boolean)new Range(3.0, true, 7.0, false).contains(8.0));
        RangeTest.assertTrue((boolean)new Range(3.0, false, 7.0, true).contains(4.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 7.0, true).contains(3.0));
        RangeTest.assertTrue((boolean)new Range(3.0, false, 7.0, true).contains(7.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 7.0, true).contains(2.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 7.0, true).contains(8.0));
        RangeTest.assertTrue((boolean)new Range(3.0, false, 7.0, false).contains(4.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 7.0, false).contains(3.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 7.0, false).contains(7.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 7.0, false).contains(2.0));
        RangeTest.assertFalse((boolean)new Range(3.0, false, 7.0, false).contains(8.0));
    }

    public void testDouble() {
        RangeTest.assertTrue((boolean)new Range(3.5, true, 7.5, true).contains(3.5));
        RangeTest.assertTrue((boolean)new Range(3.5, true, 7.5, true).contains(7.5));
        RangeTest.assertTrue((boolean)new Range(3.5, true, 7.5, false).contains(3.5));
        RangeTest.assertTrue((boolean)new Range(3.5, true, 7.5, false).contains(7.49999));
        RangeTest.assertFalse((boolean)new Range(3.5, true, 7.5, false).contains(7.5));
        RangeTest.assertFalse((boolean)new Range(3.5, false, 7.5, true).contains(3.5));
        RangeTest.assertTrue((boolean)new Range(3.5, false, 7.5, true).contains(7.49999));
        RangeTest.assertTrue((boolean)new Range(3.5, false, 7.5, true).contains(7.5));
        RangeTest.assertFalse((boolean)new Range(3.5, false, 7.5, false).contains(3.5));
        RangeTest.assertTrue((boolean)new Range(3.5, false, 7.5, false).contains(7.49999));
        RangeTest.assertFalse((boolean)new Range(3.5, false, 7.5, false).contains(7.5));
    }

    public void testNegativeNumbers() {
        RangeTest.assertTrue((boolean)new Range(-3.5, true, 7.5, true).contains(3.0));
        RangeTest.assertTrue((boolean)new Range(-3.5, true, 7.5, true).contains(-3.5));
        RangeTest.assertTrue((boolean)new Range(-3.5, true, 7.5, true).contains(7.5));
    }
}

