/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.util.Arrays;
import junit.framework.TestCase;
import org.conqat.lib.commons.options.CmdLine;

public class CmdLineTest
extends TestCase {
    private static final String[] args = new String[]{"-d", "testDir", "-o", "test 1", "test 2", "-x"};
    private static final String[] args2 = new String[]{"/d", "testDir", "/o", "test 1", "test 2", "/x"};
    private final CmdLine cmdLine = new CmdLine(args);
    private final CmdLine cmdLine2 = new CmdLine(args2, "/");

    public void testGetParameterCount() {
        CmdLineTest.assertEquals((int)6, (int)this.cmdLine.getParameterCount());
        CmdLineTest.assertEquals((int)6, (int)this.cmdLine2.getParameterCount());
    }

    public void testGetValues() {
        Object[] expected = new String[]{"test 1", "test 2"};
        CmdLineTest.assertTrue((boolean)Arrays.equals(expected, this.cmdLine.getValues("o")));
        CmdLineTest.assertTrue((boolean)Arrays.equals(expected, this.cmdLine2.getValues("o")));
    }

    public void testGetValue() {
        CmdLineTest.assertEquals((String)"testDir", (String)this.cmdLine.getValue("d"));
        CmdLineTest.assertEquals((String)"testDir", (String)this.cmdLine2.getValue("d"));
        CmdLineTest.assertEquals((String)"test 1", (String)this.cmdLine.getValue("o"));
        CmdLineTest.assertEquals((String)"test 1", (String)this.cmdLine2.getValue("o"));
    }

    public void testHasParameter() {
        CmdLineTest.assertTrue((boolean)this.cmdLine.hasParameter("d"));
        CmdLineTest.assertTrue((boolean)this.cmdLine.hasParameter("o"));
        CmdLineTest.assertTrue((boolean)this.cmdLine.hasParameter("x"));
        CmdLineTest.assertFalse((boolean)this.cmdLine.hasParameter("y"));
        CmdLineTest.assertTrue((boolean)this.cmdLine2.hasParameter("d"));
        CmdLineTest.assertTrue((boolean)this.cmdLine2.hasParameter("o"));
        CmdLineTest.assertTrue((boolean)this.cmdLine2.hasParameter("x"));
        CmdLineTest.assertFalse((boolean)this.cmdLine2.hasParameter("y"));
    }

    public void testHasParameterAndValue() {
        CmdLineTest.assertTrue((boolean)this.cmdLine.hasParameterAndValue("d"));
        CmdLineTest.assertTrue((boolean)this.cmdLine.hasParameterAndValue("o"));
        CmdLineTest.assertFalse((boolean)this.cmdLine.hasParameterAndValue("x"));
        CmdLineTest.assertFalse((boolean)this.cmdLine.hasParameterAndValue("y"));
        CmdLineTest.assertTrue((boolean)this.cmdLine2.hasParameterAndValue("d"));
        CmdLineTest.assertTrue((boolean)this.cmdLine2.hasParameterAndValue("o"));
        CmdLineTest.assertFalse((boolean)this.cmdLine2.hasParameterAndValue("x"));
        CmdLineTest.assertFalse((boolean)this.cmdLine2.hasParameterAndValue("y"));
    }
}

