/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.options;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import junit.framework.TestCase;
import org.conqat.lib.commons.options.Options;

public class OptionsTest
extends TestCase {
    private static final String[] testContent = new String[]{"# Input file for JUnit test", "", "# Option without value", "param0", "", "# used by testGetValue()", "param1    = test1", "", "# used by testGetValue() and testGetValues()", "paramList = test1 test2  \"test   3\" test4", "", "# used by testHasBooleanValue()", "bool1 = true", "bool2 = false", "bool3 = notBool", "", "# used by testHasIntValue()", "int1 = 33", "int2 = -13", "int3 = notInt", "enum1 = RED", "enum2= red", "enum3=noColor", "enum4 = brown-red", "enum5=brown_red"};
    private File inputFile;
    private Options options;

    public void setUp() throws IOException {
        this.options = new Options();
        this.createTestFile();
        this.options.init(this.inputFile.getAbsolutePath());
    }

    public void tearDown() {
        this.inputFile.delete();
    }

    private void createTestFile() throws IOException {
        this.inputFile = new File("options.test.tmp");
        BufferedWriter out = new BufferedWriter(new FileWriter(this.inputFile));
        String[] stringArray = testContent;
        int n = testContent.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            out.write(element);
            out.newLine();
            ++n2;
        }
        out.close();
    }

    public void testHasOption() {
        boolean value = this.options.hasOption("bool1");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.hasOption("param0");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.hasOption("not_present");
        OptionsTest.assertFalse((boolean)value);
    }

    public void testHasValue() {
        boolean value = this.options.hasValue("bool1");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.hasValue("param0");
        OptionsTest.assertFalse((boolean)value);
        value = this.options.hasValue("not_present");
        OptionsTest.assertFalse((boolean)value);
    }

    public void testCountValues() {
        int count = this.options.countValues("param0");
        OptionsTest.assertEquals((int)0, (int)count);
        count = this.options.countValues("param1");
        OptionsTest.assertEquals((int)1, (int)count);
        count = this.options.countValues("paramList");
        OptionsTest.assertEquals((int)4, (int)count);
        count = this.options.countValues("not_present");
        OptionsTest.assertEquals((int)-1, (int)count);
    }

    public void testGetValue() {
        String value = this.options.getValue("param1");
        String expected = "test1";
        OptionsTest.assertEquals((String)expected, (String)value);
        value = this.options.getValue("not_present", "test1");
        OptionsTest.assertEquals((String)expected, (String)value);
        value = this.options.getValue("paramList");
        expected = "test1 test2  \"test   3\" test4";
        OptionsTest.assertEquals((String)expected, (String)value);
    }

    public void testGetValues() {
        String[] values = this.options.getValues("paramList");
        OptionsTest.assertEquals((String)"test1", (String)values[0]);
        OptionsTest.assertEquals((String)"test2", (String)values[1]);
        OptionsTest.assertEquals((String)"test   3", (String)values[2]);
        OptionsTest.assertEquals((String)"test4", (String)values[3]);
    }

    public void testHasBooleanValue() {
        boolean value = this.options.hasBooleanValue("bool1");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.hasBooleanValue("bool2");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.hasBooleanValue("bool3");
        OptionsTest.assertFalse((boolean)value);
        value = this.options.hasBooleanValue("not_present");
        OptionsTest.assertFalse((boolean)value);
    }

    public void testGetBooleanValue() throws Options.ValueConversionException {
        boolean value = this.options.getBooleanValue("bool1");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.getBooleanValue("bool2");
        OptionsTest.assertFalse((boolean)value);
        try {
            value = this.options.getBooleanValue("bool3");
            OptionsTest.fail();
        }
        catch (Options.ValueConversionException valueConversionException) {
            // empty catch block
        }
        value = this.options.getBooleanValue("bool3", false);
        OptionsTest.assertFalse((boolean)value);
    }

    public void testHasIntValue() {
        boolean value = this.options.hasIntValue("int1");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.hasIntValue("int2");
        OptionsTest.assertTrue((boolean)value);
        value = this.options.hasIntValue("int3");
        OptionsTest.assertFalse((boolean)value);
        value = this.options.hasIntValue("not_present");
        OptionsTest.assertFalse((boolean)value);
    }

    public void testGetIntValue() throws Options.ValueConversionException {
        int value = this.options.getIntValue("int1");
        OptionsTest.assertEquals((int)33, (int)value);
        value = this.options.getIntValue("int2");
        OptionsTest.assertEquals((int)-13, (int)value);
        try {
            value = this.options.getIntValue("int3");
            OptionsTest.fail();
        }
        catch (Options.ValueConversionException valueConversionException) {
            // empty catch block
        }
        value = this.options.getIntValue("bool3", 55);
        OptionsTest.assertEquals((int)55, (int)value);
    }

    public void testGetEnumValue() throws Options.ValueConversionException {
        Colors actual = this.options.getEnumValue("enum1", Colors.class);
        OptionsTest.assertEquals((Object)((Object)Colors.RED), (Object)((Object)actual));
        actual = this.options.getEnumValue("enum2", Colors.class);
        OptionsTest.assertEquals((Object)((Object)Colors.RED), (Object)((Object)actual));
        try {
            actual = this.options.getEnumValue("enum3", Colors.class);
            OptionsTest.fail();
        }
        catch (Options.ValueConversionException valueConversionException) {
            // empty catch block
        }
        actual = this.options.getEnumValue("enum4", Colors.class);
        OptionsTest.assertEquals((Object)((Object)Colors.BROWN_RED), (Object)((Object)actual));
        actual = this.options.getEnumValue("enum5", Colors.class);
        OptionsTest.assertEquals((Object)((Object)Colors.BROWN_RED), (Object)((Object)actual));
        actual = this.options.getEnumValue("enum3", Colors.GREEN, Colors.class);
        OptionsTest.assertEquals((Object)((Object)Colors.GREEN), (Object)((Object)actual));
        actual = this.options.getEnumValue("enumX", Colors.GREEN, Colors.class);
        OptionsTest.assertEquals((Object)((Object)Colors.GREEN), (Object)((Object)actual));
    }

    public void testSetOption() {
        boolean overriden = this.options.setOption("option5", "value5");
        String actual = this.options.getValue("option5");
        OptionsTest.assertEquals((String)"value5", (String)actual);
        OptionsTest.assertFalse((boolean)overriden);
        overriden = this.options.setOption("option5", "value5");
        OptionsTest.assertTrue((boolean)overriden);
    }

    private static enum Colors {
        RED,
        GREEN,
        BLUE,
        BROWN_RED;

    }
}

