/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import java.util.ArrayList;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.collections.IdentityHashSet;
import org.conqat.lib.commons.collections.UniqueIdManager;
import org.conqat.lib.commons.color.ECCSMColor;
import org.conqat.lib.commons.string.StringUtils;

public class ClassLoaderGraphCreator {
    public static final String HEADER = "digraph G {" + StringUtils.CR + "  edge [  fontname = \"Helvetica\"," + StringUtils.CR + "          color = \"#639CCE\", fontsize = 8 ];" + StringUtils.CR + "  node [  shape = polygon," + StringUtils.CR + "          sides = 4," + StringUtils.CR + "          color = \"#639CCE\"," + StringUtils.CR + "          fontname = \"Helvetica\"," + StringUtils.CR + "          fontsize    = 9," + StringUtils.CR + "          height=0.25];" + StringUtils.CR;
    private final UniqueIdManager<Object> idManager = new UniqueIdManager();
    private final IdentityHashSet<Object> objects = new IdentityHashSet();
    private final IdentityHashSet<Class<?>> classes = new IdentityHashSet();
    private final IdentityHashSet<ClassLoader> classLoaders = new IdentityHashSet();

    public ClassLoaderGraphCreator(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof Class) {
                this.addClass((Class)object);
            } else {
                this.addObject(object);
            }
            ++n2;
        }
    }

    public void addObject(Object object) {
        CCSMPre.isFalse(object == null, "Object may not be null.");
        this.objects.add(object);
        this.addClass(object.getClass());
    }

    public void addClass(Class<?> clazz) {
        CCSMPre.isFalse(clazz == null, "Class may not be null.");
        this.classes.add(clazz);
        this.classLoaders.addAll(ClassLoaderGraphCreator.getClassLoaders(clazz));
    }

    private static List<ClassLoader> getClassLoaders(Class<?> clazz) {
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ClassLoader loader = clazz.getClassLoader();
        while (loader != null) {
            loaders.add(loader);
            loader = loader.getParent();
        }
        loaders.add(null);
        return loaders;
    }

    public String createClassLoaderGraph() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.valueOf(HEADER) + StringUtils.CR);
        builder.append(this.createVertices());
        builder.append(this.createEdges());
        builder.append("}" + StringUtils.CR);
        return builder.toString();
    }

    private String createEdges() {
        StringBuilder result = new StringBuilder();
        for (Object object : this.objects) {
            this.appendEdge(result, object, object.getClass());
        }
        for (Class clazz : this.classes) {
            this.appendEdge(result, clazz, clazz.getClassLoader());
        }
        for (ClassLoader classLoader : this.classLoaders) {
            if (classLoader == null) continue;
            this.appendEdge(result, classLoader, classLoader.getParent());
        }
        return result.toString();
    }

    private void appendEdge(StringBuilder builder, Object start, Object end) {
        String edge = String.valueOf(this.makeId(start)) + " -> " + this.makeId(end) + ";" + StringUtils.CR;
        builder.append(edge);
    }

    private String createVertices() {
        StringBuilder result = new StringBuilder();
        for (Object object : this.objects) {
            result.append(this.createVertex(object, ECCSMColor.GREEN));
        }
        for (Class clazz : this.classes) {
            result.append(this.createVertex(clazz, ECCSMColor.RED));
        }
        for (ClassLoader classLoader : this.classLoaders) {
            result.append(this.createVertex(classLoader, ECCSMColor.BLUE));
        }
        return result.toString();
    }

    private String createVertex(Object node, ECCSMColor color) {
        StringBuilder result = new StringBuilder();
        result.append(this.makeId(node));
        result.append(" [label=\"" + this.makeLabel(node) + "\", ");
        result.append(" color=\"" + color.getHTMLColorCode() + "\"");
        result.append("];" + StringUtils.CR);
        return result.toString();
    }

    private String makeLabel(Object object) {
        String result;
        if (object == null) {
            result = "Bootstrap Loader";
        } else if (object instanceof Class) {
            result = ((Class)object).getName();
        } else if (object instanceof ClassLoader) {
            result = object.toString();
        } else {
            String toString = object.toString();
            if (StringUtils.isEmpty(toString)) {
                toString = "instance of " + object.getClass().getName();
            }
            result = toString;
        }
        result = StringUtils.replaceLineBreaks(result, " ");
        result = result.replace('\"', '\'');
        return result;
    }

    private String makeId(Object object) {
        return "id" + this.idManager.obtainId(object);
    }
}

