/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.lib.commons.reflect;

import org.conqat.lib.commons.assertion.CCSMPre;
import org.conqat.lib.commons.enums.EnumUtils;

public enum EJavaPrimitive {
    VOID(Void.TYPE, Void.class),
    BYTE(Byte.TYPE, Byte.class),
    CHAR(Character.TYPE, Character.class),
    DOUBLE(Double.TYPE, Double.class),
    FLOAT(Float.TYPE, Float.class),
    INT(Integer.TYPE, Integer.class),
    LONG(Long.TYPE, Long.class),
    SHORT(Short.TYPE, Short.class),
    BOOLEAN(Boolean.TYPE, Boolean.class);

    private final Class<?> primitiveClass;
    private final Class<?> wrapperClass;

    private EJavaPrimitive(Class<?> primitiveClass, Class<?> wrapperClass) {
        CCSMPre.isTrue(primitiveClass.isPrimitive(), "Clazz object must be a primitive.");
        this.primitiveClass = primitiveClass;
        this.wrapperClass = wrapperClass;
    }

    public Class<?> getClassObject() {
        return this.primitiveClass;
    }

    public Class<?> getWrapperClass() {
        return this.wrapperClass;
    }

    public static EJavaPrimitive getPrimitive(String name) {
        return EnumUtils.valueOf(EJavaPrimitive.class, name);
    }

    public static EJavaPrimitive getPrimitiveIgnoreCase(String name) {
        return EnumUtils.valueOfIgnoreCase(EJavaPrimitive.class, name);
    }

    public static EJavaPrimitive getForPrimitiveClass(Class<?> clazz) {
        EJavaPrimitive[] eJavaPrimitiveArray = EJavaPrimitive.values();
        int n = eJavaPrimitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            EJavaPrimitive javaPrimitive = eJavaPrimitiveArray[n2];
            if (javaPrimitive.primitiveClass.equals(clazz)) {
                return javaPrimitive;
            }
            ++n2;
        }
        return null;
    }

    public static EJavaPrimitive getForWrapperClass(Class<?> clazz) {
        EJavaPrimitive[] eJavaPrimitiveArray = EJavaPrimitive.values();
        int n = eJavaPrimitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            EJavaPrimitive javaPrimitive = eJavaPrimitiveArray[n2];
            if (javaPrimitive.wrapperClass.equals(clazz)) {
                return javaPrimitive;
            }
            ++n2;
        }
        return null;
    }

    public static EJavaPrimitive getForPrimitiveOrWrapperClass(Class<?> clazz) {
        EJavaPrimitive[] eJavaPrimitiveArray = EJavaPrimitive.values();
        int n = eJavaPrimitiveArray.length;
        int n2 = 0;
        while (n2 < n) {
            EJavaPrimitive javaPrimitive = eJavaPrimitiveArray[n2];
            if (javaPrimitive.primitiveClass.equals(clazz) || javaPrimitive.wrapperClass.equals(clazz)) {
                return javaPrimitive;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isWrapperType(Class<?> clazz) {
        return EJavaPrimitive.getForWrapperClass(clazz) != null;
    }
}

